% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fm_verma.R
\name{fm_verma}
\alias{fm_verma}
\title{Fuzzy monetary poverty estimation}
\usage{
fm_verma(predicate, weight, ID, HCR, interval, alpha, breakdown, verbose)
}
\arguments{
\item{predicate}{A numeric vector of a predicate variable (i.e. equivalised income or expenditure)}

\item{weight}{A numeric vector of sampling weights. if NULL simple random sampling weights will be used.}

\item{ID}{A numeric or character vector of IDs. if NULL (the default) it is set as the row sequence.}

\item{HCR}{The value of the head count ratio (this is not used in the case that alpha is supplied by the user).}

\item{interval}{A numeric vector of length two to look for the value of alpha (if not supplied).}

\item{alpha}{The value of the exponent in equation $E(mu)^(alpha-1) = HCR$. If NULL it is calculated so that it equates the expectation of the membership function to HCR}

\item{breakdown}{A factor of sub-domains to calculate estimates for (using the same alpha).}

\item{verbose}{Logical. whether to print the proceeding of the procedure.}
}
\value{
A list containing the (fuzzy) membership function for each individual in the sample, the estimated expected value of the function, the alpha parameter.
}
\description{
\code{fm_construct} constructs fuzzy monetary poverty estimates.
}
\details{
It implements the fuzzy set approach to monetary poverty measurement where
the usual dichotomy poor (1) not-poor(0) is replaced with a continuum score in $(0,1)$
}
