## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----message=FALSE, warning=FALSE---------------------------------------------
library(Fiscore)

## -----------------------------------------------------------------------------
pdb_path<- system.file("extdata", "6kz5.pdb", package="Fiscore")


pdb_df<-PDB_process(pdb_path)
pdb_df


## -----------------------------------------------------------------------------
pdb_path<-system.file("extdata", "6kz5_A.pdb", package="Fiscore")
pdb_df<-PDB_prepare(pdb_path)
head(pdb_df)


## -----------------------------------------------------------------------------

phi_psi_plot(pdb_df)


## -----------------------------------------------------------------------------

phi_psi_bar_plot(pdb_df)


## -----------------------------------------------------------------------------

phi_psi_interactive(pdb_df)


## -----------------------------------------------------------------------------

B_plot_normalised(pdb_df)


## -----------------------------------------------------------------------------

phi_psi_3D(pdb_df)


## -----------------------------------------------------------------------------
Fi_score_plot(pdb_df)

## -----------------------------------------------------------------------------
Fi_score_region(pdb_df,50,70)

## -----------------------------------------------------------------------------
Fiscore_secondary(pdb_df)

## -----------------------------------------------------------------------------
hydrophobicity_plot(pdb_df,window = 9,weight = 25,model = "linear")

## -----------------------------------------------------------------------------
hydrophobicity_plot(pdb_df,window = 9,weight = 25,model = "exponential")

## -----------------------------------------------------------------------------
df<-cluster_ID(pdb_df)


## -----------------------------------------------------------------------------
df<-cluster_ID(pdb_df,clusters = 5, modelNames = "VVI")


## -----------------------------------------------------------------------------
density_plots(pdb_df)

## -----------------------------------------------------------------------------
density_plots(pdb_df, df)

