#' @title FisPro package
#' @name FisPro-package
#' @docType package
#' @description This package is a basic implementation of the main functions to use a Fuzzy Inference Systems that can be used for reasoning purposes, especially for simulating a physical or biological system. It is derived from the 'FisPro' open source software \url{https://www.fispro.org}. Fuzzy inference systems are briefly described in the \href{https://www.fispro.org/documentation/en/inline-help/node39.html}{Fuzzy Logic Elementary Glossary}. They are based on fuzzy rules, which have a good capability for managing progressive phenomenons. Fuzzy logic, since the pioneer work by Zadeh, has proven to be a powerful interface between symbolic and numerical spaces. One of the reasons for this success is the ability of fuzzy systems to incorporate human expert knowledge with its nuances, as well as to express the behaviour of the system in an interpretable way for humans. Another reason is the possibility of designing data-driven FIS to make the most of available data. \cr
#' To design a fuzzy system that can be handled by this package the user can use the 'FisPro' software. If needed, the package can be extended to other functions. \cr
#' Enjoy FisPro!
#' @author FisPro Team \email{contact@fispro.org}
#' @useDynLib FisPro
#' @import Rcpp
#' @importFrom Rdpack reprompt
#'
#' @references{
#'   \url{https://www.fispro.org}
#'
#'   \insertRef{Guillaume2011}{FisPro}
#'
#'   \insertRef{ExpertSystems12}{FisPro}
#' }
#'
NULL
