# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title fis class
#' @name fis
#' @docType class
#' @description The fis class is the main class (Rcpp class) to open and use a Fuzzy Inference System.
#'
#' @field name the name of the FIS.
#' @field input_size the number of inputs in the FIS.
#' @field output_size the number of outputs in the FIS.
#'
#' @section Methods:
#' \describe{
#' \item{constructor}{argument: \code{fis_file} a FIS configuration file (can be built with FisPro software \url{https://www.fispro.org}). \cr return: an object of fis.}
#' \item{infer}{infers a value for each output from the input values \cr argument: \code{values} numerical vector of input values. \cr return: all infered outputs.}
#' \item{infer_output}{infers a value for a single output from the input values \cr argument: \code{values} numerical vector of input values. \cr argument: \code{output_number} the number of the output to infer. \cr return: the infered output.}
#' }
#' 
#' @references{
#'   \href{https://www.fispro.org/documentation/en/inline-help/node39.html}{Fuzzy Logic Elementary Glossary}
#' }
#'
#' @examples
#' # build the FIS
#' fis_file <- system.file("extdata", "test.fis", package = "FisPro")
#' fis <- new(fis, fis_file)
#'
#' # infer all outputs
#' infered <- fis$infer(c(0.25, 0.75))
#' #infer first output
#' infered_output1 <- fis$infer_output(c(0.25, 0.75), 0)
#' #infer second output
#' infered_output2 <- fis$infer_output(c(0.25, 0.75), 1)
#'
#' @export fis
NULL

#' @title mf class
#' @docType class
#' @name mf
#' @description Base class of all MF classes. This class cannot be instantiate. Use derived classes \link{mf_triangular}, \link{mf_trapezoidal}, \link{mf_trapezoidal_inf} or \link{mf_trapezoidal_sup}
#'
#' @field name the name of the mf.
#'
#' @section Methods:
#' \describe{
#' \item{\code{degree(value)}}{compute the membership degree of a numerical value. \cr argument: \code{value} numerical value to compute the membership degree. \cr return: the membership degree.}
#' }
#' 
#' @references{
#'   \href{https://www.fispro.org/documentation/en/inline-help/node39.html}{Fuzzy Logic Elementary Glossary}
#' }
#'
#' @export mf
NULL

#' @title mf_triangular class
#' @name mf_triangular
#' @docType class
#' @description Class to build triangular MF.
#'
#' @section Inherits:
#' mf_triangular class inherits all fields and methods of \link{mf} class.
#'
#' @section Methods:
#' \describe{
#' \item{\code{constructor(lower_support, kernel, upper_support)}}{argument: \code{lower_support} numerical lower value of support. \cr argument: \code{kernel} numerical value of kernel. \cr argument: \code{upper_support} numerical upper value of support. \cr return: an object of mf_triangular.}
#' }
#'
#' @examples
#' mf <- new(mf_triangular, 0, 1, 2)
#' mf$degree(0.5)
#'
#' @export mf_triangular
NULL

#' @title mf_trapezoidal_inf class
#' @name mf_trapezoidal_inf
#' @docType class
#' @description Class to build trapezoidal inf MF.
#'
#' @section Inherits:
#' mf_trapezoidal_inf class inherits all fields and methods of \link{mf} class.
#'
#' @section Methods:
#' \describe{
#' \item{\code{constructor(upper_kernel, upper_support)}}{argument: \code{upper_kernel} numerical upper value of kernel. \cr argument: \code{upper_support} numerical upper value of support. \cr return: an object of mf_trapezoidal_inf.}
#' }
#'
#' @examples
#' mf <- new(mf_trapezoidal_inf, 0, 1)
#' mf$degree(0.5)
#'
#' @export mf_trapezoidal_inf
NULL

#' @title mf_trapezoidal_sup class
#' @name mf_trapezoidal_sup
#' @docType class
#' @description Class to build trapezoidal sup MF.
#'
#' @section Inherits:
#' mf_trapezoidal_sup class inherits all fields and methods of \link{mf} class.
#'
#' @section Methods:
#' \describe{
#' \item{\code{constructor(lower_support, lower_kernel)}}{argument: \code{lower_support} numerical lower value of support. \cr argument: \code{lower_kernel} numerical lower value of kernel. \cr return: an object of mf_trapezoidal_sup.}
#' }
#'
#' @examples
#' mf <- new(mf_trapezoidal_sup, 0, 1)
#' mf$degree(0.5)
#'
#' @export mf_trapezoidal_sup
NULL

#' @title mf_trapezoidal class
#' @name mf_trapezoidal
#' @docType class
#' @description Class to build trapezoidal MF.
#'
#' @section Inherits:
#' mf_trapezoidal class inherits all fields and methods of \link{mf} class.
#'
#' @section Methods:
#' \describe{
#' \item{\code{constructor(lower_support, lower_kernel, upper_kernel, upper_support)}}{argument: \code{lower_support} numerical lower value of support. \cr argument: \code{lower_kernel} numerical lower value of kernel. \cr argument: \code{upper_kernel} numerical upper value of kernel. \cr argument: \code{upper_support} numerical upper value of support. \cr return: an object of mf_trapezoidal.}
#' }
#'
#' @examples
#' mf <- new(mf_trapezoidal, 0, 1, 2, 3)
#' mf$degree(0.5)
#'
#' @export mf_trapezoidal
NULL

