% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/StatFactor.Cov.R
\name{StatFactor.Cov}
\alias{StatFactor.Cov}
\title{Covariance Matrix Estimation by Statistical Factor Model}
\usage{
StatFactor.Cov(assets, k = 0)
}
\arguments{
\item{assets}{a matrix of asset returns}

\item{k}{numbers of factors, if k = 0,
automatically estimating by Kaiser method}
}
\value{
an estimated p*p covariance matrix
}
\description{
Estimate covariance matrix by fitting a statistical factor model
using principle components analysis
}
\examples{
data(m.excess.c10sp9003)
assets <- m.excess.c10sp9003[,1:10]
StatFactor.Cov(assets, 3)
}

