% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unstructured_gxe.R
\name{unstr_asr_input}
\alias{unstr_asr_input}
\title{Simulate genetic values based on an unstructured model for GxE interaction - 'AlphaSimR' input
parameters}
\usage{
unstr_asr_input(
  n_envs = 3,
  n_traits = 2,
  mean = 0,
  var = 1,
  T_var = NULL,
  E_var = NULL,
  cor_A = NULL,
  T_cor_A = NULL,
  E_cor_A = NULL,
  mean_DD = NULL,
  var_DD = NULL,
  T_var_DD = NULL,
  E_var_DD = NULL,
  cor_DD = NULL,
  T_cor_DD = NULL,
  E_cor_DD = NULL,
  rel_AA = NULL,
  T_rel_AA = NULL,
  E_rel_AA = NULL,
  cor_AA = NULL,
  T_cor_AA = NULL,
  E_cor_AA = NULL
)
}
\arguments{
\item{n_envs}{Number of environments to be simulated. A minimum of two environments is required.}

\item{n_traits}{Number of traits to be simulated.}

\item{mean}{A vector of mean genetic values for each environment-within-trait combination.
If only one value is specified, all environment-within-trait combinations will be assigned
the same mean.}

\item{var}{A vector of genetic variances for each environment-within-trait combination.
If only one value is specified, all environment-within-trait combinations will be assigned
the same mean. \cr
\strong{Alternatively}, if a separable structure between traits and environments is desired,
\code{T_var} and \code{E_var} can be specified.}

\item{T_var}{A vector of genetic variances for each trait. Must be provided in combination with
\code{E_var}. \cr
\strong{Alternatively}, \code{var} can be specified.}

\item{E_var}{A vector of genetic variances for each environment. Must be provided in
combination with \code{T_var}. \cr
\strong{Alternatively}, \code{var} can be specified.}

\item{cor_A}{A matrix of additive genetic correlations between all environment-within-trait
combinations. By default, a diagonal matrix is constructed. \cr
\strong{Alternatively}, \code{T_cor_A} and \code{E_cor_A} can be specified.}

\item{T_cor_A}{A matrix of additive genetic correlations between traits. Must be provided in
combination with \code{E_cor_A}. \cr
\strong{Alternatively}, \code{cor_A} can be specified.}

\item{E_cor_A}{A matrix of additive genetic correlations between environments.
Must be provided in combination with \code{T_cor_A}. \cr
\strong{Alternatively}, \code{cor_A} can be specified.}

\item{mean_DD}{A vector of mean dominance degrees for each environment-within-trait combination
(similar to \code{mean}). If only one value is specified, all environment-within-trait
combinations will be assigned the same mean. By default, \code{mean_DD = NULL} and dominance
is not simulated.}

\item{var_DD}{A vector of dominance degree variances for each environment-within-trait
combination (similar to \code{var}). If only one value is specified, all environment-within-trait
combinations will be assigned the same variance. \cr
\strong{Alternatively}, if a separable structure between traits and environments is desired,
\code{T_var_DD} and \code{E_var_DD} can be specified.}

\item{T_var_DD}{A vector of dominance degree variances for each trait (similar to \code{T_var}).
Must be provided in combination with \code{E_var_DD}. \cr
\strong{Alternatively}, \code{var_DD} can be specified.}

\item{E_var_DD}{A vector of dominance degree genetic variances for each environment (similar to
\code{E_var}). Must be provided in combination with \code{T_var_DD}. \cr
\strong{Alternatively}, \code{var_DD} can be specified.}

\item{cor_DD}{A matrix of dominance degree correlations between all environment-within-trait
combinations (similar to \code{cor_A}). If not specified and dominance is simulated, a
diagonal matrix is constructed. \cr
\strong{Alternatively}, \code{T_cor_DD} and \code{E_cor_DD} can be specified.}

\item{T_cor_DD}{A matrix of dominance degree correlations between traits (similar to
\code{T_cor_A}). Must be provided in combination with \code{E_cor_DD}. \cr
\strong{Alternatively}, \code{cor_DD} can be specified.}

\item{E_cor_DD}{A matrix of dominance degree correlations between environments (similar to
\code{E_cor_A}). Must be provided in combination with \code{T_cor_DD}. \cr
\strong{Alternatively}, \code{cor_DD} can be specified.}

\item{rel_AA}{A vector defining the magnitude of additive-by-additive (epistatic) variance
relative to additive genetic variance for each environment-within-trait combination,
that is in a diploid organism with allele frequency 0.5. If only one value is specified,
all environment-within-trait combinations will be assigned the same value. By default,
\code{rel_AA = NULL} and epistasis is not simulated. \cr
\strong{Alternatively}, if a separable structure between traits and environments is desired,
\code{T_rel_AA} and \code{E_rel_AA} can be specified.}

\item{T_rel_AA}{A vector defining the magnitude of additive-by-additive (epistatic) variance
relative to the additive genetic variance for each trait. Must be provided in combination
with \code{E_rel_AA}. \cr
\strong{Alternatively}, \code{rel_AA} can be specified.}

\item{E_rel_AA}{A vector defining the magnitude of additive-by-additive (epistatic) variance
relative to the additive genetic variance for each environment. Must be provided in
combination with \code{T_rel_AA}. \cr
\strong{Alternatively}, \code{rel_AA} can be specified.}

\item{cor_AA}{A matrix of epistatic correlations between all environment-within-trait
combinations (similar to \code{cor_A}). If not specified and epistasis is simulated, a
diagonal matrix is constructed. \cr
\strong{Alternatively}, \code{T_cor_AA} and \code{E_cor_AA} can be specified.}

\item{T_cor_AA}{A matrix of epistatic correlations between traits (similar to \code{T_cor_A}).
Must be provided in combination with \code{E_cor_AA}. \cr
\strong{Alternatively}, \code{cor_AA} can be specified.}

\item{E_cor_AA}{A matrix of epistatic correlations between environments (similar to
\code{E_cor_A}). Must be provided in combination with \code{T_cor_AA}. \cr
\strong{Alternatively}, \code{cor_AA} can be specified.}
}
\value{
A list containing input parameters for 'AlphaSimR', which is used to simulate
  correlated genetic effects based on an unstructured model.
}
\description{
Creates a list of input parameters for
\href{https://CRAN.R-project.org/package=AlphaSimR}{'AlphaSimR'} to simulate
genetic values for multiple traits across multiple environments based on an unstructured model
for genotype-by-environment (GxE) interaction. \cr
By default, 'AlphaSimR' does not support complex models for GxE interaction. However, its
functionality to simulate correlated genetic values can be utilised for this purpose by
providing the required variance structures. \code{unstr_asr_input} is a wrapper function to
construct the variance structures required to simulate GxE interaction in 'AlphaSimR' based on
a multi-trait unstructured model. This function can handle separable and non-separable structures between traits and
environments (see below). After simulating the genetic values, the wrapper function
\link[FieldSimR]{unstr_asr_output} can be used to obtain a data frame with the relevant values.
}
\details{
\code{unstr_asr_input} can handle separable and non-separable structures between traits and
environments.
\itemize{
  \item For separable structures, provide (1) \code{T_var} & \code{E_var}, and (2)
  \code{T_cor_A} & \code{E_cor_A}.
  \item For non-separable structures, provide (1) \code{var}, and (2) \code{cor_A}. \cr
  }

\strong{Note:} 'AlphaSimR' can simulate different biological effects (see:
\href{https://gaynorr.github.io/AlphaSimR/reference/SimParam.html}{SimParam}).
\itemize{
  \item For additive traits use \code{addTraitA()}.
  \item For additive + dominance traits use \code{addTraitAD()}.
  \item For additive + epistatic traits use \code{addTraitAE()}.
  \item For additive + dominance + epistatic traits use \code{addTraitADE()}.
  }
If non-additive effects are to be simulated, check the \code{useVarA} argument of these
functions.
}
\examples{
# Simulate genetic values in 'AlphaSimR' for two additive + dominance traits across
# three environments based on an unstructured model for GxE interaction.

# 1. Define the genetic architecture of the simulated traits.
# Mean genetic values and mean dominance degrees.
mean <- c(4.9, 5.4, 5.1, 235.2, 228.5, 239.1) # Trait 1 x 3 environments, trait 2 x 3 environments.
mean_DD <- c(0.4, 0.4, 0.4, 0.1, 0.1, 0.1) # Trait 1 and 2, same values in the three environments.

# Additive genetic variances and dominance degree variances.
var <- c(0.085, 0.12, 0.06, 15.1, 8.5, 11.7) # Trait 1 x 3 environments, trait 2 x 3 environments.
var_DD <- rep(0.2, 6) # The same value set for traits 1 and 2.

# Additive genetic correlations between the two simulated traits.
T_cor_A <- matrix(
  c(
    1.0, 0.6,
    0.6, 1.0
  ),
  ncol = 2
)

# Additive genetic correlations between the three simulated environments.
E_cor_A <- matrix(
  c( # Matrix of additive genetic correlations between the three environments.
    1.0, 0.4, 0.6,
    0.4, 1.0, 0.5,
    0.6, 0.5, 1.0
  ),
  ncol = 3
)

# Dominance degree correlations between all six environment-within-trait combinations.
cor_DD <- diag(6) # Assuming independence between traits

input_asr <- unstr_asr_input(
  n_envs = 3,
  n_traits = 2,
  mean = mean,
  var = var,
  T_cor_A = T_cor_A,
  E_cor_A = E_cor_A,
  mean_DD = mean_DD,
  var_DD = var_DD,
  cor_DD = cor_DD
)
}
