% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_data.R
\name{extractData}
\alias{extractData}
\title{Datasets dfData, mData, tData, xData, zData, extractData : extractData}
\usage{
extractData(pr = "p", ft = "tss", start = "2007-01-01",
  end = "2013-12-31")
}
\arguments{
\item{pr}{character. Extract prices or returns: \code{c("p","r","prices","returns")}.}

\item{ft}{character. Output format among \code{c("tss","xts","zoo","dfr","bfr","mat")}.}

\item{start}{character. Start date.}

\item{end}{character. End date.}
}
\description{
dfData, mData, tData, xData, zData are datasets made of lists of data.frame, matrix, 
timeSeries, xts and zoo components. They describe prices and returns of 10 financial series
used in the documents and demos presented at 8th and 9th R/Rmetrics conferences  
(2014, 2015). See the references. 
The last serie (CHF, interest rates in Switzerland) exhibits negative prices. 
All distributions of logreturns exhibit fat tails.
Function \code{extractData} converts subsets of mData, tData, xData, zData.
}
\examples{
   

library(zoo) 
library(xts) 
library(timeSeries) 

### dfData, tData, xData, zData : prices only
attributes(dfData); attributes(tData); attributes(xData); attributes(zData) 
lapply(dfData, head, 3)
lapply( mData, head, 3)
lapply( tData, head, 3)
lapply( xData, head, 3)
lapply( zData, head, 3)

### extractData : prices and logreturns
head(ptD <- extractData("p", "tss", "2009-01-01", "2012-12-31")) ; tail(ptD)
head(rtD <- extractData("r", "tss")) 
head(pxD <- extractData("p", "xts")) 
head(rxD <- extractData("r", "xts")) 
head(pzD <- extractData("p", "zoo")) 
head(rzD <- extractData("r", "zoo")) 
head(pbD <- extractData("p", "bfr")) 
head(rbD <- extractData("r", "bfr")) 
head(pmD <- extractData("p", "mat")) 
head(rmD <- extractData("r", "mat")) 

### Remove item CHF (negative prices) from dfData, tData, xData, zData
Z <- dfData[names(dfData)[1:9]]; attributes(Z)
Z <- tData[names(tData)[1:9]]; attributes(Z)
Z <- xData[names(xData)[1:9]]; attributes(Z)
Z <- zData[names(zData)[1:9]]; attributes(Z)

}
