% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchGenerator.R
\name{searchAlgorithm}
\alias{searchAlgorithm}
\title{Search algorithm generator}
\usage{
searchAlgorithm(searcher, params = list())
}
\arguments{
\item{searcher}{Name of the search algorithm. The available search algorithms are:
\describe{
\item{antColony}{Ant colony optimization (ACO). See \code{\link{antColony}} }
\item{breadthFirst}{Breadth first search. See \code{\link{breadthFirst}} }
\item{deepFirst}{Deep first search. See \code{\link{deepFirst}} }
\item{geneticAlgorithm}{Genetic algorithm (GA). See \code{\link{geneticAlgorithm}} }
\item{hillClimbing}{Hill-Climbing (HC). See \code{\link{hillClimbing}} }
\item{LasVegas}{Las Vegas (LV). See \code{\link{LasVegas}} }
\item{sequentialBackwardSelection}{Sequential backward selection (sbs). See \code{\link{sequentialBackwardSelection}} }
\item{sequentialFloatingForwardSelection}{Sequential floating forward selection (sffs). See \code{\link{sequentialFloatingForwardSelection}} }
\item{sequentialFloatingBackwardSelection}{Sequential floating backward selection (sfbs). See \code{\link{sequentialFloatingBackwardSelection}} }
\item{sequentialForwardSelection}{Sequential forward selection (sfs). See \code{\link{sequentialForwardSelection}} }
\item{simulatedAnnealing}{Simulated annealing (SA). See \code{\link{simulatedAnnealing}} }
\item{tabu}{Tabu search (TS). See \code{\link{tabu}} }
\item{whaleOptimization}{Whale optimization algorithm (WOA). See \code{\link{whaleOptimization}} }
}}

\item{params}{List with the parameters of each search method. For more details see each method. Default: empty list.}
}
\value{
Returns a search function that is used to guide the feature selection process
}
\description{
Generates a search function. This function in combination with the evaluator guides the feature selection process. Specifically, the result of calling this function is another function that is passed on as a parameter to the \code{\link{featureSelection}} function. However, you can run this function directly to perform a search process in the features space.
}
\examples{
\donttest{ 

## Examples of a search algorithm generation

search_method_1 <- searchAlgorithm('antColony')
search_method_2 <- searchAlgorithm('sequentialBackwardSelection')
search_method_3 <- searchAlgorithm('tabu')


## Examples of a search algorithm generation (with parameters)

search_method_1 <- searchAlgorithm('antColony', list(population=25, iter=50, verbose=TRUE))
search_method_2 <- searchAlgorithm('sequentialBackwardSelection', list(stop=TRUE))
search_method_3 <- searchAlgorithm('tabu', list(intensification=1, iterIntensification=25))


## The direct application of this function is an advanced use that consists of using this 
# function directly to perform a search process on a feature space
## Classification problem

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('IEConsistency')

# Generates the search function
search_method <- searchAlgorithm('hillClimbing')
# Performs the search process directly (parameters: dataset, target variable and evaluator)
search_method(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
