% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relief.R
\name{normalizedRelief}
\alias{normalizedRelief}
\title{Normalized Relief}
\usage{
normalizedRelief(neighbours.count = 5, sample.size = 10)
}
\arguments{
\item{neighbours.count}{\itemize{
\item number of neighbours to find for every sampled instance
}}

\item{sample.size}{\itemize{
\item number of instances to sample
}}
}
\value{
Returns a function that is used to generate an individual evaluation measure using relief
}
\description{
Generates an evaluation function that calculates a measure of the set of features between 0 and 1 with relief (individual measure). The relief algorithm \insertCite{Kira1992}{FSinR} finds weights of continous and discrete attributes basing on a distance between instances. Adapted from Piotr Romanski's Fselector package \insertCite{FSelectorPkg}{FSinR}. This function is called internally within the \code{\link{filterEvaluator}} function.
}
\details{
relief
classification and regression
continous and discrete data
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly to individually evaluate a set of features
## Classification problem

# Generate the evaluation function with Cramer
relief_evaluator <- normalizedRelief()
# Evaluate the features (parameters: dataset, target variable and features)
relief_evaluator(iris,'Species',c('Sepal.Length'))
}
}
\references{
\insertAllCited{}
}
\author{
Alfonso Jiménez-Vílchez
}
