% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{run_all_simulations}
\alias{run_all_simulations}
\title{Run every simulation in an FSK object}
\usage{
run_all_simulations(fsk_object, run_visualization = FALSE)
}
\arguments{
\item{fsk_object}{Instance of FSK2R}

\item{run_visualization}{Whether to call the visualization script. FALSE
by default.}
}
\value{
None
}
\description{
Runs every simulation defined in the FSK object. This includes
the ones originally included in the FSK container, as well as
the ones added using set_new_simulation().
}
\examples{
\donttest{
 path_example <- system.file("extdata", "ToyModelv4.fskx", package = "FSK2R")
 my_fsk <- import_fsk(path_example)
 run_all_simulations(my_fsk)
}

}
