## -----------------------------------------------------------------------------
# install.packages("FSK2R")

## -----------------------------------------------------------------------------
library(FSK2R)

## -----------------------------------------------------------------------------
path_example <- system.file("extdata", "ToyModelv4.fskx", package = "FSK2R")
print(path_example)

## -----------------------------------------------------------------------------
my_fsk <- import_fsk(path_example)

## -----------------------------------------------------------------------------
class(my_fsk)

## -----------------------------------------------------------------------------
is.FSK2R(my_fsk)

## -----------------------------------------------------------------------------
names(my_fsk)

## -----------------------------------------------------------------------------
my_fsk$manifest

## -----------------------------------------------------------------------------
my_fsk$model

## -----------------------------------------------------------------------------
my_fsk$packages

## -----------------------------------------------------------------------------
my_fsk$readme

## -----------------------------------------------------------------------------
cat(my_fsk$R_model)

## -----------------------------------------------------------------------------
cat(my_fsk$visualization)

## -----------------------------------------------------------------------------
model_path <- system.file("extdata", "model.r", package = "FSK2R")
print(model_path)

## -----------------------------------------------------------------------------
visualization_path <- system.file("extdata", "visualization.r", package = "FSK2R")
print(visualization_path)

## -----------------------------------------------------------------------------
FSK_from_R <- create_fsk(model_path, visualization_path)

## -----------------------------------------------------------------------------
class(FSK_from_R)

## -----------------------------------------------------------------------------
names(FSK_from_R)

## -----------------------------------------------------------------------------
FSK_from_R$model_metadata

## -----------------------------------------------------------------------------
is_fsk_with_r(FSK_from_R)

## -----------------------------------------------------------------------------
n_simuls_fsk(FSK_from_R)

## -----------------------------------------------------------------------------
run_simulation(FSK_from_R, 1)

## -----------------------------------------------------------------------------
run_simulation(FSK_from_R, 1, TRUE)

## -----------------------------------------------------------------------------
new_model <- set_new_simulation(my_fsk, "new", 
                                list(r = 0.09,
                                     Dose_matrix = "as.matrix(read.table(file =\"Dose_matrix.csv\",sep=\",\", header = TRUE, row.names=1))",
                                     alpha = 0.05,
                                     beta = 0.045,
                                     eta = 0.003
                                     )
                                )

## -----------------------------------------------------------------------------
n_simuls_fsk(new_model)

## -----------------------------------------------------------------------------
readme_text <- "This is an FSK-ML compliant model generated based on an existing R script"
FSK_from_R <- set_readme(FSK_from_R, readme_text)

## -----------------------------------------------------------------------------
get_readme(FSK_from_R)

## -----------------------------------------------------------------------------
# get_simulations(my_fsk)

## -----------------------------------------------------------------------------
get_general_info(my_fsk)

## -----------------------------------------------------------------------------
get_scope(my_fsk)

## -----------------------------------------------------------------------------
get_background(my_fsk)

## -----------------------------------------------------------------------------
get_modelmath(my_fsk)

## ---- eval=FALSE--------------------------------------------------------------
#  # download_metadata_schema("my_template.xlsx")

## -----------------------------------------------------------------------------
template_path <- system.file("extdata", "example_template.xlsx", package = "FSK2R")
print(template_path)

## -----------------------------------------------------------------------------
FSK_from_R <- read_fsk_metadata_excel(FSK_from_R, template_path)

## -----------------------------------------------------------------------------
export_fsk(my_fsk, out_path=file.path(tempdir(), "out.fskx"))

## -----------------------------------------------------------------------------
imported_model <- import_fsk(file.path(tempdir(), "out.fskx"))

