% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/plottingfns.R
\name{plot}
\alias{plot}
\alias{plot,SRE,STFDF-method}
\alias{plot,SRE,SpatialPointsDataFrame-method}
\alias{plot,SRE,SpatialPixelsDataFrame-method}
\alias{plot,SRE,SpatialPolygonsDataFrame-method}
\title{Plot predictions from FRK analysis}
\usage{
plot(x, y, ...)

\S4method{plot}{SRE,STFDF}(x, y, ...)

\S4method{plot}{SRE,SpatialPointsDataFrame}(x, y, ...)

\S4method{plot}{SRE,SpatialPixelsDataFrame}(x, y, ...)

\S4method{plot}{SRE,SpatialPolygonsDataFrame}(x, y, ...)
}
\arguments{
\item{x}{object of class \code{SRE}}

\item{y}{the \code{Spatial*DataFrame} or \code{STFDF} object resulting from the call \code{predict(x)}. 
Keep in mind that \code{predict()} returns a \code{list} when \code{method} = "TMB"; the element \code{$newdata} contains the required \code{Spatial}/\code{ST} object. 
If the list itself is passed, you will receive the error: "x" and "y" lengths differ.}

\item{...}{optional arguments passed on to \code{\link{plot_spatial_or_ST}}}
}
\value{
A list of \code{ggplot} objects consisting of the observed data, predictions, and standard errors. This list can then be supplied to, for example, \code{ggpubr::ggarrange()}.
}
\description{
This function acts as a wrapper around 
\code{\link{plot_spatial_or_ST}}. It plots the fields of the 
\code{Spatial*DataFrame} or \code{STFDF} object corresponding to 
prediction and prediction uncertainty quantification. It also uses the 
\code{@data} slot of \code{SRE} object to plot the training data set(s), 
and generates informative, latex-style legend labels for each of the plots.
}
\examples{
## See example in the help file for SRE
}
