% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/geometryfns.R
\docType{methods}
\name{BAUs_from_points}
\alias{BAUs_from_points}
\alias{BAUs_from_points,SpatialPoints-method}
\alias{BAUs_from_points,ST-method}
\title{Creates pixels around points}
\usage{
BAUs_from_points(obj, offset = 1e-10)

\S4method{BAUs_from_points}{SpatialPoints}(obj, offset = 1e-10)

\S4method{BAUs_from_points}{ST}(obj, offset = 1e-10)
}
\arguments{
\item{obj}{object of class \code{SpatialPointsDataFrame}}

\item{offset}{edge size of the mini-BAU (default 1e-10)}
}
\description{
Takes a SpatialPointsDataFrame and converts it into SpatialPolygonsDataFrame by constructing a tiny (within machine tolerance) BAU around each SpatialPoint.
}
\details{
This function allows users to mimic standard geospatial analysis where BAUs are not used. Since \code{FRK} is built on the concept of a BAU, this function constructs tiny BAUs around the observation and prediction locations that can be subsequently passed on to the functions \code{SRE} and \code{FRK}. With \code{BAUs_from_points}, the user supplies both the data and prediction locations accompanied with covariates.
}
\examples{
library(sp)
opts_FRK$set("parallel",0L)
df <- data.frame(x = rnorm(10),
                 y = rnorm(10))
coordinates(df) <- ~x+y
BAUs <- BAUs_from_points(df)
}
\seealso{
\code{\link{auto_BAUs}} for automatically constructing generic BAUs.
}
