% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FIT.R
\name{make.recipe}
\alias{make.recipe}
\title{Creates a recipe for training models.}
\usage{
make.recipe(envs, init, optim, fit, init.data, time.step, gate.open.min = 0,
  opts = NULL)
}
\arguments{
\item{envs}{An array of weather factors to be taken into account
during the construction of models.
At the moment, the array \code{envs} can only contain a single weather factor
from \code{weather.entries}, though there is a plan to remove the restriction
in a future version.}

\item{init}{A string to specify the method to choose the initial parameters.
(One of \code{'gridsearch'} or \code{'manual'}.)}

\item{optim}{A string to specify the method to be used for optimizing
the model parameters.
(One of \code{'none'}, \code{'lm'} or \code{'lasso'})}

\item{fit}{A string to specify the method to be used for fixing
the linear regression coefficients.
(One of \code{'fit.lm'} or \code{'fit.lasso'}.)}

\item{init.data}{Auxiliary data needed to perform the Init stage
using the method specified by the \code{init} argument.
When \code{init} is \code{'gridsearch'}, it should be a list representing
a discretized parameter space.
When \code{init} is \code{'manual'}, it should be a list of parameter
values that is used as the initial values for the parameters in
the Optim stage.}

\item{time.step}{An integer to specify the basic unit of time (in minute)
for the transcriptomic models.
Must be a multiple of the time step of weather data.}

\item{gate.open.min}{The minimum opning length in minutes of the gate function for 
environmental inputs.}

\item{opts}{An optional named list that specifies the arguments to be passed
    to methods that constitute each stage of the model training.
    Each key of the list corresponds to a name of a method.

    See examples for the supported options.}
}
\value{
An object representing the procedure to construct models.
}
\description{
Creates a recipe for training models.
}
\examples{
\dontrun{
init.params <- .. # choose them wisely
# Defined in Train.R:
# default.opts <- list(
#   none  = list(),
#   lm    = list(maxit=1500, nfolds=-1), # nfolds for lm is simply ignored
#   lasso = list(maxit=1000, nfolds=10)
# )
recipe <- FIT::make.recipe(c('wind', 'temperature'),
                           init = 'manual',
                           init.data = init.params,
                           optim = c('lm', 'none', 'lasso'),
                           fit = 'fit.lasso',
                           time.step = 10,
                           opts =
                             list(lm    = list(maxit = 900),
                                  lasso = list(maxit = 1000)))
}

}
