% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_analysis.R
\name{rasterToVRT}
\alias{rasterToVRT}
\title{Write a GDAL virtual raster file (VRT)}
\usage{
rasterToVRT(
  srcfile,
  relativeToVRT = 0,
  vrtfile = tempfile("tmprast", fileext = ".vrt"),
  resolution = NULL,
  subwindow = NULL,
  align = TRUE,
  resampling = "nearest"
)
}
\arguments{
\item{srcfile}{Source raster file name.}

\item{relativeToVRT}{Integer. Should \code{srcfile} be interpreted as 
relative to the .vrt file (value is 1) or not relative to the .vrt file
(value is 0)? If value is 1, the .vrt file is assumed to be in the same 
directory as \code{srcfile} and \code{basename(srcfile)} is used in .vrt.}

\item{vrtfile}{Output VRT file name.}

\item{resolution}{A numeric vector of length two, with xres, yres. The pixel
size must be expressed in georeferenced units. Both must be positive values.
The source pixel size is used if resolution is not specified.}

\item{subwindow}{A numeric vector of length four, with xmin, ymin, xmax and 
    ymax values (e.g., sp::bbox or sf::st_bbox). Selects a subwindow of the 
source raster with corners given in georeferenced coordinates (in the 
source CRS). If not given, the upper left corner of the VRT will be the 
same as source, and the VRT extent will be the same or larger than source 
depending on resolution.}

\item{align}{Logical scalar. If TRUE, the upper left corner of the VRT 
extent will be set to the upper left corner of the source pixel that 
contains subwindow xmin, ymax. The VRT will be pixel-aligned with source 
if the VRT resolution is the same as the source pixel size, otherwise VRT 
extent will be the minimum rectangle that contains subwindow for the given 
pixel size. If FALSE, the VRT upper left corner be exactly subwindow xmin, 
ymax, and the VRT extent will be the minimum rectangle that contains 
subwindow for the given pixel size. If subwindow is not given, the source 
window is the source raster extent in which case align=FALSE has no effect.}

\item{resampling}{The resampling method to use if xsize, ysize of the VRT is
different from the size of the underlying source rectangle (in number of
pixels). The values allowed are nearest, bilinear, cubic, cubicspline, 
lanczos, average and mode.}
}
\description{
Write a GDAL VRT file for a source raster with options for repositioning and
and resampling the source data at a different pixel resolution
}
\details{
\code{rasterToVRT} is useful for virtually clipping a raster to a subwindow,
or virtually resampling at a different pixel resolution. The output VRT file
will have the same coordinate system as the source raster.
}
