% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFFTrees_function.R
\name{plot.FFTrees}
\alias{plot.FFTrees}
\title{Draws a FFTrees object.}
\usage{
\method{plot}{FFTrees}(x = NULL, data = "train", which.tree = NULL,
  tree = "best.train", main = "Data", n.per.icon = NULL,
  decision.names = c("Noise", "Signal"), ...)
}
\arguments{
\item{x}{A FFTrees object created from \code{"FFTrees()"}}

\item{data}{Either a dataframe of new data, or one of two strings 'train' or 'test'. In this case, the corresponding dataset in the x object will be used.}

\item{which.tree}{depreciated argument, only for backwards compatibility, use \code{"tree"} instead.}

\item{tree}{An integer indicating which tree to plot (only valid when the tree argument is non-empty). To plot the best training (or test) tree with respect to v (HR - FAR), use "best.train" or "best.test"}

\item{main}{The main plot label.}

\item{n.per.icon}{Number of exemplars per icon}

\item{decision.names}{A string vector of length 2 indicating the content-specific name for noise and signal cases.}

\item{...}{Currently ignored.}
}
\description{
The primary purpose of this function is to visualize a Fast and Frugal Tree (FFT) for data that has already been classified using the FFTrees() function. However, if the data have not yet been classified, the function can also implement a tree specified by the user. Inputs with the (M) header are manditory. If the tree has already been implimented, then only inputs with the (A) header should be entered. If the tree has not been implimented, then only inputs with the (B) header should be entered.
}
\examples{


# See the vignette for details

vignette("FFTrees_plot", package = "FFTrees")



}

