% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_aux.R
\name{plot.FCVAR_grid}
\alias{plot.FCVAR_grid}
\title{Plot the Likelihood Function for the FCVAR Model}
\usage{
\method{plot}{FCVAR_grid}(x, y = NULL, ...)
}
\arguments{
\item{x}{An S3 object of type \code{FCVAR_grid} output from \code{FCVARlikeGrid}.}

\item{y}{An argument for generic method \code{plot} that is not used in \code{plot.FCVAR_grid}.}

\item{...}{Arguments to be passed to methods, such as graphical parameters
for the generic plot function.}
}
\description{
\code{plot.FCVAR_grid} plots the likelihood function from \code{FCVARlikeGrid}.
\code{FCVARlikeGrid} performs a grid-search optimization
by calculating the likelihood function
on a grid of candidate parameter values.
This function evaluates the likelihood over a grid of values
	for \code{c(d,b)} (or \code{phi}, when  there are constraints on \code{c(d,b)}).
	It can be used when parameter estimates are sensitive to
	starting values to give an approximation of the global max which can
	then be used as the starting value in the numerical optimization in
	\code{FCVARestn}.
}
\note{
Calls \code{graphics::persp} when \code{x$Grid2d == TRUE} and
calls \code{graphics::plot} when \code{x$Grid2d == FALSE}.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$dbStep1D     <- 0.1 # Coarser grid for plotting example.
opt$dbStep2D     <- 0.2 # Coarser grid for plotting example.
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
opt$progress <- 2 # Show progress report on each value of b.
likeGrid_params <- FCVARlikeGrid(x, k = 2, r = 1, opt)
graphics::plot(likeGrid_params)
}
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{plot.FCVAR_grid} plots the likelihood function from \code{FCVARlikeGrid}.

Other FCVAR auxiliary functions: 
\code{\link{FCVARforecast}()},
\code{\link{FCVARlikeGrid}()},
\code{\link{FCVARsimBS}()},
\code{\link{FCVARsim}()},
\code{\link{FracDiff}()}
}
\concept{FCVAR auxiliary functions}
