% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_spec.R
\name{FCVARbootRank}
\alias{FCVARbootRank}
\title{Distribution of LR Test Statistic for the Rank Test}
\usage{
FCVARbootRank(x, k, opt, r1, r2, B)
}
\arguments{
\item{x}{A matrix of variables to be included in the system.
If \code{k>0}, actual data is used for initial values.}

\item{k}{The number of lags in the system.}

\item{opt}{An S3 object of class \code{FCVAR_opt} that stores the chosen estimation options,
generated from \code{FCVARoptions()}.}

\item{r1}{The cointegrating rank under the null hypothesis.}

\item{r2}{The cointegrating rank under the alternative hypothesis.}

\item{B}{The number of bootstrap samples.}
}
\value{
A list \code{FCVARbootRank_stats} containing the test results,
including the following parameters:
\describe{
  \item{\code{LRbs}}{A B x 1 vector of simulated likelihood ratio statistics.}
  \item{\code{pv}}{An approximate p-value for the LR statistic based on the bootstrap distribution. }
  \item{\code{H}}{A list containing LR test results. It is
  identical to the output from \code{HypoTest}, with one addition,
  namely \code{H$pvBS} which is the bootstrap p-value)}
  \item{\code{mBS}}{Model estimates under the null hypothesis. }
  \item{\code{mUNR}}{Model estimates under the alternative hypothesis. }
}
}
\description{
\code{FCVARbootRank} generates a distribution of a likelihood ratio
 test statistic for the rank test using a wild bootstrap,
following the method of Cavaliere, Rahbek, and Taylor (2010). It
 takes the two ranks as inputs to estimate the model under the
 null and the model under the alternative.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
opt$plotRoots <- 0
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
set.seed(42)
FCVARbootRank_stats <- FCVARbootRank(x, k = 2, opt, r1 = 0, r2 = 1, B = 2)
# In practice, set the number of bootstraps so that (B+1)*alpha is an integer,
# where alpha is the chosen level of significance.
# For example, set B = 999 (but it takes a long time to compute).
}
}
\references{
Cavaliere, G., A. Rahbek, and A. M. R. Taylor (2010).
"Testing for co-integration in vector autoregressions
with non-stationary volatility," Journal of Econometrics 158, 7-24.
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{HypoTest} for the format of a hypothesis test results.
\code{FCVARestn} for the estimates from a rectricted and unrestricted model within a hypothesis test.

Other FCVAR specification functions: 
\code{\link{FCVARlagSelect}()},
\code{\link{FCVARrankTests}()},
\code{\link{summary.FCVAR_lags}()},
\code{\link{summary.FCVAR_ranks}()}
}
\concept{FCVAR specification functions}
