% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlp_teach.R
\name{mlp_teach_rprop}
\alias{mlp_teach_rprop}
\title{Rprop teaching}
\usage{
mlp_teach_rprop(net, input, output, tol_level, max_epochs, report_freq = 0,
  u = 1.2, d = 0.5, gmax = 50, gmin = 1e-06)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{input}{numeric matrix, each row corresponds to one input vector
number of columns must be equal to the number of neurons
in the network input layer}

\item{output}{numeric matrix with rows corresponding to expected outputs,
number of columns must be equal to the number of neurons
in the network output layer, number of rows must be equal to the number
of input rows}

\item{tol_level}{numeric value, error (MSE) tolerance level}

\item{max_epochs}{integer value, maximal number of epochs (iterations)}

\item{report_freq}{integer value, progress report frequency, if set to 0 no information is printed
on the console (this is the default)}

\item{u}{numeric value, Rprop algorithm parameter (default 1.2)}

\item{d}{numeric value, Rprop algorithm parameter (default 0.5)}

\item{gmax}{numeric value, Rprop algorithm parameter (default 50)}

\item{gmin}{numeric value, Rprop algorithm parameter (default 1e-6)}
}
\value{
Two-element list, the first field (\code{net}) contains the trained network,
        the second (\code{mse}) - the learning history (MSE in consecutive epochs).
}
\description{
Rprop is a fast and robust adaptive step method based on backpropagation.
For details, please refer to the original paper given in References section.
}
\references{
M. Riedmiller. \emph{Rprop - Description and Implementation Details: Technical Report.} Inst. f.
Logik, Komplexitat u. Deduktionssysteme, 1994.
}
\keyword{teaching}

