% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samiuddin.R
\name{samiuddin}
\alias{samiuddin}
\title{Test for homogeneity of variances of Samiuddin}
\usage{
samiuddin(trat, resp, t, r)
}
\arguments{
\item{trat}{Numeric or complex vector containing treatments.}

\item{resp}{Numeric or complex vector containing the response
variable.}

\item{t}{Number of treatments.}

\item{r}{Numeric or complex vector containing the number of
replications of each treatment.}
}
\value{
Returns the p-value of Samiuddin's test of
homogeneity of variances and its practical interpretation
for significance level of 5\%.
}
\description{
\code{samiuddin} Performs the test for homogeneity of
variances of Samiuddin (1976).
}
\examples{
data(ex1)
attach(ex1)
crd(trat, ig, quali = FALSE, hvar = "samiuddin", sigF = 0.05)
}
\references{
SAMIUDDIN, M. Bayesian test of homogeneity of
variance. \emph{Journal of the American Statistical
Association}, 71(354):515-517, Jun. 1976.

NOGUEIRA, D, P.; PEREIRA, G, M. Desempenho de testes para
homogeneidade de variancias em delineamentos inteiramente
casualizados. \emph{Sigmae}, Alfenas, v.2, n.1, p. 7-22.
2013.
}
\seealso{
\code{\link{bartlett}}, \code{\link{layard}},
\code{\link{levene}}, \code{\link{oneillmathews}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}
 @author Denismar Alves Nogueira
 @author Marcos Costa de Paula
 @author Mateus Pimenta Siqueira Lima
}
