% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedAlgo.R
\name{bedAlgo}
\alias{bedAlgo}
\title{bedAlgo: postProcessors to classify events}
\usage{
bedAlgo(model)
}
\arguments{
\item{model}{model to which the postprocessor shall be added}
}
\value{
model model with added postprocessing results
}
\description{
bedAlgo provides the continuous probability of an event at every prediction timestep.
 The memory about the recent past event is automatically included to predict the future.
 An event is initiated when the BED probability exceeds the eventThreshold.
 The probability that the data represents expected normal behavior in 'n' trials is represented as \cr
\code{B(r;n,p)=(n!)/(r!(n-r)!) p^(r) q^((n-r))}\cr
where the 'n' trials is given by 'bedWindowSize', 'q' represents the probability that a trial succeeds and 'p' represents the probability that a trial fails as an event. We keep the value of both 'p' and 'q' as 0.5 and hence the equation is simplified to\cr
\code{B(r;n,p)=(n!)(r!(n-r)!)0.5^n}\cr
The advantage of this BED is that it helps in reducing the false alarm, while the disadvantage is the slight delay in identifying the true event
}
\keyword{internal}
