% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_HistData_bis.R
\name{EN_HistData_bis}
\alias{EN_HistData_bis}
\title{Retrieve Historical Stock Data from Euronext (Bis)}
\usage{
EN_HistData_bis(
  ticker,
  from = Sys.Date() - 365 * 2,
  to = Sys.Date() - 1,
  stock_type = "Eq_Ind",
  escape = FALSE
)
}
\arguments{
\item{ticker}{A character vector or list representing the company's ticker, name, or ISIN.
It can be a single ticker or a list of tickers.}

\item{from}{The start date for historical data (default: 2 years ago).
Only dates not exceeding 2 years ago are allowed for the 'from' parameter.}

\item{to}{The end date for historical data (default: yesterday).}

\item{stock_type}{The type of the ticker: 'Eq_Ind' for Stocks and Indexes,
'Fund' or "F" for Fund tickers, 'Bond' or "B" for Bond tickers,
and 'Etfs' or "E" for ETFs.}

\item{escape}{Boolean, either TRUE or FALSE. If escape is TRUE, it means you're providing
the DNA (ISIN-Market identifier) directly. Giving TRUE to escape is helpful
to avoid time-consuming operations; otherwise, FALSE means you need to provide
the Ticker symbol, name, or ISIN and the type of market to which it belongs.}
}
\value{
A data frame containing historical stock data, including columns for Date,
Open, High, Low, Last, Close, 'Number of shares', Turnover, and VWAP.
}
\description{
This function fetches historical stock data from Euronext based on the given list of
tickers or ISINs. You can specify a date range using the 'from' and 'to' parameters.
Additionally, provide the type of the ticker as 'Eq_Ind' for Stocks and Indexes,
'Fund' or "F" for Fund tickers, 'Bond' or "B" for Bond tickers,
and 'Etfs' or "E" for ETFs.
}
\examples{
\donttest{

library(httr)
library(jsonlite)
library(rvest)
library(stringr)
library(magrittr)
library(rlang)

# Fetch historical data for ABCA , AEDIFICA and BM3EAC stocks from October 30, 2023
hc_List1 <- EN_HistData_bis(c("ABCA", "AEDIFICA", "BM3EAC"), from = "2023-10-30", to = "2024-01-27")
head(hc_List1)

# Fetch historical data for Indices such us AEX All-Share Index, AEX2S and AEX Basic Materials
hc_List2 <- EN_HistData_bis(c("AAX", "QS0011016480", "AEX2S"), from = "2023-12-15", to = Sys.Date())
head(hc_List2)

#To get historical data of Bond issued by IT0005386716-XMOT
hc_List3 <-EN_HistData_bis("XS1548458014-XAMS", escape = TRUE, from = "2022-10-30",stock_type = "B")
head(hc_List3)

# Fetch historical data for ABCA with the default date range
hc_List3 <-  EN_HistData_bis("ABCA")
head(hc_List3)

# To Get KGHDF's Fund data
hc_List4 <- EN_HistData_bis("KGHDF", stock_type = "F", from = "2022-10-30")
head(hc_List4)

#Providing Etfs vector
hc_etf <- EN_HistData_bis(c("IE0007G78AC4", "MANA", "3TSM"), stock_type = 'E')
head(hc_etf)

EN_HistData_bis("ABCAhh") # Will return "Ticker not found"
}

}
\seealso{
\code{\link{EN_GetISIN}} to retrieve the ISIN for a given ticker.

Other Data Retrieval: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()},
\code{\link{En_Market.Sumarry}()}

Other Euronext: 
\code{\link{EN_Get_News}()},
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_P_Ticker_adn}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()}
}
\concept{Data Retrieval}
\concept{Euronext}
