% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{aggAtlasExport}
\alias{aggAtlasExport}
\title{Aggregate filtered final Atlas export}
\usage{
aggAtlasExport(x, input)
}
\arguments{
\item{x}{dataframe}

\item{input}{list of parameters as defined in the Signal Detection Application (see \code{\link{runEpiSDApp}})

(i.e.  \code{list(disease, country, indicator, stratification, unit, daterange, algo, testingperiod)})}
}
\value{
dataframe aggregated by geographical level and time unit
}
\description{
Aggregate filtered final Atlas export
}
\examples{
#-- Setting the parameters to run the report for
input <- list(
disease = "Salmonellosis",
country = "EU-EEA - complete series",
indicator = "Reported cases",
stratification = "Confirmed cases",
unit = "Month",
daterange = c("2010-01-01", "2016-12-31"),
algo = "FarringtonFlexible",
testingperiod = 5
)

#-- Example dataset
dataset <- EpiSignalDetection::SignalData

#-- Filtering on declared input parameters
dataset <- filterAtlasExport(dataset, input)

#-- Aggregating the data by geographical level and time point
dataset <- aggAtlasExport(dataset, input)

}
\seealso{
\code{\link{filterAtlasExport}} \code{\link{SignalData}} \code{\link{stsSD}}
}
