% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.mod.trackers.R
\name{trackers.net}
\alias{trackers.net}
\title{Trackers: netsim Module}
\usage{
trackers.net(dat, at)
}
\arguments{
\item{dat}{Main list object containing a \code{networkDynamic} object and
other initialization information passed from \code{\link{netsim}}.}

\item{at}{Current time step.}
}
\value{
The updated \code{dat} main list object.
}
\description{
This function applies the user-provided epi trackers.
}
\section{Optional Module}{

This module is not included by default.
}

\section{The \code{tracker.list} list}{

\code{tracker.list} is a list of NAMED functions stored in the \code{control}
list of the \code{dat} main list object.
}

\section{Tracker Functions}{

This module will apply the tracker functions present in the control list
\code{tracker.list}. Each tracker must be a function with EXACTLY two
arguments: the \code{dat} main list object and \code{at} the current time
step. They must return a VALUE of length one (numeric, logical or character).
}

\examples{
\dontrun{

# Create some trackers
epi_prop_infected <- function(dat, at) {
  needed_attributes <- c("status", "active")
  output <- with(get_attr_list(dat, needed_attributes), {
    pop <- active == 1
    cond <- status == "i"

    out <- sum(cond & pop, na.rm = TRUE) / sum(pop, na.rm = TRUE)

    out
  })

  return(output)
}

epi_s_num <- function(dat, at) {
  needed_attributes <- c("status")
  output <- with(get_attr_list(dat, needed_attributes), {
    out <- sum(status == "s", na.rm = TRUE)

    out
  })

  return(output)
}

# Create the `tracker.list` list
tracker.list <- list(
  prop_infected = epi_prop_infected,
  s_num         = epi_s_num
)

 param <- param.net(
   inf.prob = 0.3,
   act.rate = 0.5
 )

# Enable the module in `control` and add the `tracker.list` element
 control <- control.net(
   type = NULL, # must be NULL as we use a custom module
   nsims = 2,
   nsteps = 5,
   verbose = FALSE,
   infection.FUN = infection.net,
   trackers.FUN = trackers.net,
   tracker.list = tracker.list
 )

nw <- network_initialize(n = 50)
nw <- set_vertex_attribute(nw, "race", rbinom(50, 1, 0.5))
est <- netest(
  nw,
  formation = ~edges,
  target.stats = 25,
  coef.diss = dissolution_coefs(~offset(edges), 10, 0),
  verbose = FALSE
)

init <- init.net(i.num = 10)
mod <- netsim(est, param, init, control)

df <- as.data.frame(mod)

df

}

}
\seealso{
\code{\link{netsim}}
}
\keyword{internal}
\keyword{netMod}
