% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{get_vertex_attribute}
\alias{get_vertex_attribute}
\title{Get Vertex Attribute on Network Object}
\usage{
get_vertex_attribute(x, attrname)
}
\arguments{
\item{x}{An object of class network.}

\item{attrname}{The name of the attribute to get.}
}
\value{
Returns an object of class \code{network}.
}
\description{
Gets a vertex attribute from an object of class \code{network}.
             This functions simplifies the related function in the
             \code{network} package.
}
\details{
This function is used in \code{EpiModel} workflows to query vertex
attributes on an initialized empty network object (see
\code{\link{network_initialize}}).
}
\examples{
nw <- network_initialize(100)
nw <- set_vertex_attribute(nw, "age", runif(100, 15, 65))
get_vertex_attribute(nw, "age")

}
