% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.mod.updater.R
\name{updater.net}
\alias{updater.net}
\title{Module to modify the controls or parameters during the simulation}
\usage{
updater.net(dat, at)
}
\arguments{
\item{dat}{Master list object containing a \code{networkDynamic} object and
other initialization information passed from \code{\link{netsim}}.}

\item{at}{Current time step.}
}
\value{
The updated \code{dat} Master list object.
}
\description{
Module to modify the controls or parameters during the simulation
}
\details{
If a list \code{param.updater.list} is present in the parameters, this module
will update the \code{param} list with new values at given timesteps.
Similarily, if a list \code{control.updater.list} is present in the controls,
this module will update the \code{param} list with new values at given
timesteps.
An updater is a list containing an \code{at} element governing when the
changes will happen, an optional \code{verbose} Boolean controlling whether
to output a message when a change is made (default = TRUE) and a \code{param}
or \code{control} named list with the names being the same as the parameter /
control names and the new value to update with. If the new value is a
function but the old one is not, the function will be applied to the current
element (see example).
}
\examples{
\dontrun{

# Create the param.updater.list
param.updater.list <- list(
  # this is one updater
  list(
    at = 10,
    param = list(
      hiv.test.rate = rep(0.0128, 3),
      trans.scale = c(1.61, 0.836, 0.622)
    )
  ),
  # this is another updater
  list(
    at = 12,
    verbose = TRUE,
    param = list(
      hiv.test.rate = function(x) x * 3,
      trans.scale = function(x) x^2 / 3
    )
  )
)

 # Add it to params
 param <- param.net(
   inf.prob = 0.3,
   act.rate = 0.5,
   hiv.test.rate = rep(0.256, 3),
   trans.scale = c(1, 2, 3),
   param.updater.list = param.updater.list
 )

# Create the control.updater.list
# these updaters will toggle on and off the verbosity of the model
control.updater.list <- list(
  list(
    at = 50,
    verbose = TRUE,
    control = list(
      verbose = TRUE
    )
  ),
  # this is another updater
  list(
    at = 75,
    verbose = TRUE,
    control = list(
      verbose = FALSE
    )
  )
)

# Enable the module in control, and add `control.updater.list` to it
 control <- control.net(
   type = NULL, # must be NULL as we use a custom module
   nsims = 1,
   nsteps = 20,
   verbose = FALSE,
   updater.FUN = updater.net,
   infection.FUN = infection.net,
   control.updater.list = control.updater.list
 )

nw <- network_initialize(n = 50)
nw <- set_vertex_attribute(nw, "race", rbinom(50, 1, 0.5))
est <- netest(
  nw,
  formation = ~edges,
  target.stats = 25,
  coef.diss = dissolution_coefs(~offset(edges), 10, 0),
  verbose = FALSE
)

init <- init.net(i.num = 10)
mod <- netsim(est, param, init, control)

}

}
