% Generated by roxygen2 (4.0.1): do not edit by hand
\name{merge.netsim}
\alias{merge.netsim}
\title{Merge Model Simulations Across netsim Objects}
\usage{
\method{merge}{netsim}(x, y, keep.transmat = TRUE, keep.network = TRUE,
  keep.nwstats = TRUE, ...)
}
\arguments{
\item{x}{an \code{EpiModel} object of class \code{\link{netsim}}.}

\item{y}{another \code{EpiModel} object of class \code{\link{netsim}},
with the identical model parameterization as \code{x}.}

\item{keep.transmat}{if \code{TRUE}, keep the transmission matrices
from the original \code{x} and \code{y} elements.}

\item{keep.network}{if \code{TRUE}, keep the
\code{networkDynamic} objects from the original \code{x} and \code{y}
elements.}

\item{keep.nwstats}{if \code{TRUE}, keep the network
statistics (as set by the \code{nwstats.formula} parameter in
\code{control.netsim}) from the original \code{x} and \code{y} elements.}

\item{...}{additional merge arguments (not used).}
}
\description{
Merges epidemiological data from two independent simulations of
             stochastic network models from \code{netsim}.
}
\details{
This merge function combines the results of two independent simulations of
\code{\link{netsim}} class models, simulated under separate function calls. The
model parameterization between the two calls must be exactly the same, except
for the number of simulations in each call. This allows for manual
parallelization of model simulations.

This merge function does not work the same as the default merge in
allowing for a combined object where the structure differs between the
input elements. Instead, the function checks that objects are identical
in model parameterization in every respect (except number of simulations) and
binds the results.
}
\examples{
# Network model
nw <- network.initialize(n = 100, directed = FALSE)
dissolution <- ~offset(edges)
coef.diss <- dissolution_coefs(dissolution, duration = 10)
est <- netest(nw,
              formation = ~ edges,
              dissolution = ~offset(edges),
              target.stats = 25,
              coef.diss = coef.diss,
              verbose = FALSE)

# Epidemic models
param <- param.net(trans.rate = 1)
init <- init.net(i.num = 1)
control <- control.net(type = "SI", nsteps = 20, nsims = 2,
                       save.nwstats = TRUE,
                       nwstats.formula = ~ edges + degree(0),
                       verbose = FALSE)
x <- netsim(est, param, init, control)
y <- netsim(est, param, init, control)

# Merging
z <- merge(x, y)
x$epi
y$epi
z$epi
}
\keyword{extract}

