% Generated by roxygen2 (4.0.1): do not edit by hand
\name{merge.icm}
\alias{merge.icm}
\title{Merge Data across Stochastic Individual Contact Model Simulations}
\usage{
\method{merge}{icm}(x, y, ...)
}
\arguments{
\item{x}{an \code{EpiModel} object of class \code{\link{icm}}.}

\item{y}{another \code{EpiModel} object of class \code{\link{icm}}, with the
identical model parameterization as \code{x}.}

\item{...}{additional merge arguments (not used).}
}
\description{
Merges epidemiological data from two independent simulations of
             stochastic individual contact models from \code{icm}.
}
\details{
This merge function combines the results of two independent simulations of
\code{\link{icm}} class models, simulated under separate function calls. The
model parameterization between the two calls must be exactly the same, except
for the number of simulations in each call. This allows for manual
parallelization of model simulations.

This merge function does not work the same as the default merge in
allowing for a combined object where the structure differs between the
input elements. Instead, the function checks that objects are identical
in model parameterization in every respect (except number of simulations) and
binds the results.
}
\examples{
param <- param.icm(trans.rate = 0.2, act.rate = 0.8,)
init <- init.icm(s.num = 1000, i.num = 100)
control <- control.icm(type = "SI", nsteps = 10,
                       nsims = 3, verbose = FALSE)
x <- icm(param, init, control)

control <- control.icm(type = "SI", nsteps = 10,
                       nsims = 1, verbose = FALSE)
y <- icm(param, init, control)

z <- merge(x, y)
x$epi
y$epi
z$epi
}
\keyword{extract}

