\name{infection}
\alias{infection}
\title{Primary Infection Module for epiNet.simTrans}
\usage{
infection(all, at)
}
\arguments{
  \item{all}{a list object containing a
  \code{networkDynamic} object and other initialization
  information passed from \code{\link{epiNet.simTrans}}.}

  \item{at}{current time step.}
}
\value{
The main \code{all} object is returned with updated disease
status and summary incidence measures.
}
\description{
This function simulates the main infection process given
the current state of the partnerships and disease in the
system.
}
\details{
The main steps in this infection module are as follows:
\enumerate{ \item Get IDs for current infected and
susceptibles given the current disease status.  \item Call
\code{\link{discord.edgelist}} to get the current
discordant edgelist given step 1.  \item Determine the
transmission rates (e.g., as a function of mode).  \item
Pull the number of acts per partnership in a time step from
the \code{act.rate} parameter.  \item Calculate the final
transmission probabilities given the transmission rates and
act rates.  \item Randomly transmit on the discordant
edgelist.  \item Conduct bookkeeping for new infections to
update status on the nodes and calculate disease incidence.
}
}
\seealso{
\code{\link{discord.edgelist}} is used within
\code{infection} to obtain discordant edgelist.
}
\keyword{epiNetModule}
\keyword{internal}

