% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envnj.R
\name{envnj}
\alias{envnj}
\title{Build Trees Based on the Environment Around the Indicated Amino Acid(s)}
\usage{
envnj(data, r = 10, aa = 'all', outgroup = 'any')
}
\arguments{
\item{data}{input data must be a dataframe where each row corresponds to a protein sequence and each column to a species.}

\item{r}{a positive integer indicating the radius of the sequence segment considered as environment.}

\item{aa}{the amino acid(s) to be used to encoded the species.}

\item{outgroup}{when a rooted tree is desired, it indicates the species to be used as outgroup.}
}
\value{
A list with two objects, the first one is an inter-species distance matrix. The second one is an object of class 'phylo'.
}
\description{
Builds trees based on the environment around the indicated amino acid(s).
}
\details{
This function builds alignment-independent phylogenetic trees.
}
\examples{
\donttest{
data(bovids)
envnj(bovids[, 7:11], aa = "all", outgroup = "Pseudoryx_nghetinhensis")
}
}
\seealso{
otu.space()
}
