% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLASS__MinimizationResult.R
\docType{class}
\name{OptimizationResults}
\alias{OptimizationResults}
\title{EmiR optimization results}
\description{
A S4 class storing all relevant data from an optimization with EmiR.
}
\section{Slots}{

\describe{
\item{\code{algorithm}}{the name of the algorithm.}

\item{\code{iterations}}{the number of iterations.}

\item{\code{population_size}}{the number of individuals in the population.}

\item{\code{obj_function}}{the minimized/maximized objective function.}

\item{\code{constraints}}{the constraints the objective function is subjected to.}

\item{\code{best_cost}}{the best value of the objective function found.}

\item{\code{best_parameters}}{the parameter values for which the best cost was obtained.}

\item{\code{parameter_range}}{the range on the parameters.}

\item{\code{pop_history}}{list containing the positions of all individuals in the
population at each iteration. The list is filled only if \code{save_pop_history}
is \code{TRUE} in the options of the minimizer (see \link[EmiR]{MinimizerOpts}).}

\item{\code{cost_history}}{the vector storing the best value of the objective function at
each iteration.}

\item{\code{exec_time_sec}}{the execution time in seconds.}

\item{\code{is_maximization}}{if \code{TRUE} the objective function has been maximized insted of
being minimized.}
}}

