% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_point_df.R
\name{generate_point_df}
\alias{generate_point_df}
\title{Generate a data frame with points above the treeline}
\usage{
generate_point_df(gstRaster, gslRaster, stepSize = 0.0416666,
                        gstTreshold = 6.4, gslTreshold = 94)
}
\arguments{
\item{gstRaster}{Climatic raster that contains the growing season temperature. Data type "SpatRaster".}

\item{gslRaster}{Climatic raster that contains the growing season length. Data type "SpatRaster".}

\item{stepSize}{Step size for the sampling (in degree). This defines how fare the coordinates are apart. One value, data type "numeric" and finite.}

\item{gstTreshold}{Growing season temperature threshold for tree growth (in degree Celsius). One value, data type "numeric" and finite.}

\item{gslTreshold}{Growing season length threshold for tree growth (days). One value, data type "integer" and finite.}
}
\value{
Data frame that contains coordinates of points above the treeline.
}
\description{
A data frame is generated containing only points that are at or above the treeline.
The calculation of the treeline (when using default thresholds) is based on Paulsen and Körner,
Alp. Bot. 124: 1-12 (2014).
}
\examples{
#Get raster layer from CHELSA
gstURL <- paste0("https://os.zhdk.cloud.switch.ch/chelsav2/GLOBAL/",
                 "climatologies/1981-2010/bio/CHELSA_gst_1981-2010_V.2.1.tif")
gslURL <- paste0("https://os.zhdk.cloud.switch.ch/chelsav2/GLOBAL/",
                 "climatologies/1981-2010/bio/CHELSA_gsl_1981-2010_V.2.1.tif")
\donttest{
gst <- terra::rast(gstURL, vsi = TRUE)
gsl <- terra::rast(gslURL, vsi = TRUE)

#Now generate a example data frame
temp <- generate_point_df(gstRaster = gst, gslRaster = gsl, stepSize = 10,
                         gstTreshold = 6.4, gslTreshold = 94)
}
}
\author{
Livio Bätscher, Jurriaan M. de Vos
}
