% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsembleSample-class.R
\docType{class}
\name{EnsembleSample-class}
\alias{EnsembleSample-class}
\title{A class to hold  samples of the ensemble model}
\description{
\code{EnsembleSample} objects are generated using the \code{generate_sample} function.
}
\section{Slots}{

\describe{
\item{\code{ensemble_fit}}{An \code{EnsembleFit} object containing the fitted ensemble model.}

\item{\code{mle}}{An \code{array} of dimension \eqn{T \times (M + 2)\times N_{sample}} containing MLE point estimates from the \code{ensemble_fit} object, where \eqn{T} is the total time, \eqn{M} is the number of simulators and \eqn{N_{sample}} is the number of samples. For each time step, the \code{t}th element of the array is a \code{matrix} where each column is a sample and the rows are the variables:
\deqn{\left( y^{(t)}, \eta^{(t)}, z_1^{(t)}, z_2^{(t)}, \ldots, z_M^{(t)}\right)'}
where \eqn{y^{(t)}} is the ensemble model's prediction of the latent truth value at time \eqn{t},
\eqn{\eta^{(t)}} is the shared short-term discrepancy at time \eqn{t},
\eqn{z_i^{(t)}} is the individual short-term discrepancy of simulator \eqn{i} at time \eqn{t}.}

\item{\code{samples}}{An \code{array} of dimension \eqn{T \times (M + 2)\times N_{sample}} containing samples from the \code{ensemble_fit} object, where \eqn{T} is the total time, \eqn{M} is the number of simulators and \eqn{N_{sample}} is the number of samples. For each time step, the \code{t}th element of the array is a \code{matrix} where each column is a sample and the rows are the variables:
\deqn{\left( y^{(t)}, \eta^{(t)}, z_1^{(t)}, z_2^{(t)}, \ldots, z_M^{(t)}\right)'}
where \eqn{y^{(t)}} is the ensemble model's prediction of the latent truth value at time \eqn{t},
\eqn{\eta^{(t)}} is the shared short-term discrepancy at time \eqn{t},
\eqn{z_i^{(t)}} is the individual short-term discrepancy of simulator \eqn{i} at time \eqn{t}.}
}}

\seealso{
\code{\link{EnsembleSample}}, \code{\link{generate_sample}}
}
