% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscrepancyPrior-IndSTPrior-class.R
\docType{class}
\name{IndSTPrior-class}
\alias{IndSTPrior-class}
\title{A class to hold the priors for the ensemble model.}
\description{
An \code{IndSTPrior} object encapsulates the prior information for the short-term discrepancies of the individual simulators within the ensemble model.
}
\details{
Individual short-term discrepancies \eqn{z_k^{(t)}} are modelled as an AR(1) process so that \deqn{z_k^{(t+1)} \sim N(R_k z_k^{(t)}, \Lambda_k).} Accepted parametrisation forms for this discrepancy are \code{lkj}, \code{beta}, \code{inv_wishart}, or \code{hierarchical}. See details of the \code{EnsemblePrior()} constructor for more details.
}
\section{Slots}{

\describe{
\item{\code{AR_param}}{The parameters giving the beta parameters for the autoregressive parameter of the AR(1) process.}

\item{\code{parametrisation_form}}{The parametrisation by which the covariance matrix of the noise of the AR process is decomposed.}

\item{\code{var_params}}{The parameters characterising the variance of the AR process on the individual short-term discrepancy.}

\item{\code{cor_params}}{The parameters characterising the correlations of the AR process on the individual short-term discrepancy. .}
}}

\seealso{
\code{\linkS4class{IndLTPrior}}, \code{\linkS4class{ShaSTPrior}}, \code{\linkS4class{TruthPrior}},
}
