% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eztune.R
\name{eztune}
\alias{eztune}
\title{Supervised Learning Function}
\usage{
eztune(x, y, type = "binary", method = "ada", optimizer = "optim",
  cv = FALSE, fold = 10)
}
\arguments{
\item{x}{Matrix or data frame containing the dependent variables.}

\item{y}{Numeric vector of 0s and 1s for the response.}

\item{type}{Type of response (binary is the only option at this time).}

\item{method}{Model to be fit. Choices are "ada" for adaboost, "gbm" for
gradient boosting machines, and "svm" for support vector machines.}

\item{optimizer}{Optimization method. Options are "ga" to use a genetic
algorithm to optimize and "optim" to use a quasi-Newton-Raphson optimizer.}

\item{cv}{Indicates if the cross-validation accuracy should be used to fit.
FALSE to use resubstitution accuracy to optimize (faster but less accurate)
and TRUE to use cross-validation accuracy (slower and more accurate).}

\item{fold}{The number of folds to use for n-fold cross validation. This is
ignored if cv = FALSE.}
}
\value{
Function returns a summary of the fitted tuning parameters,
 the accuracy, and the best model.

\item{summary}{Matrix that contains the values of the tuning parameters
 and the final accuracy.}
\item{accuracy}{Best accuracy obtained by optimizing algorithm.}
\item{best.model}{Model using optimized parameters. Adaboost model
 comes from package ada, gbm model comes from package gbm, svm
 model comes from package e1071.}
\item{iter}{Tuning parameter for adaboost.}
\item{nu}{Tuning parameter for adaboost.}
\item{loss}{Loss used in adaboost fitting.}
\item{interaction.depth}{Tuning parameter for gbm.}
\item{n.trees}{Tuning parameter for gbm.}
\item{shrinkage}{Tuning parameter for gbm.}
\item{cost}{Tuning parameter for svm.}
\item{epsilon}{Tuning parameter for svm.}
\item{kernel}{Kernel used in svm fitting.}
}
\description{
eztune is a single function that will tune adaboost, support vector
machines, and gradient boosting machines. It currently only
tunes models with a binary response. An optimizer is used to find
a good set of tuning parameters for the selected model. The
function optimizes on either the resubstitution accuracy or the
cross-validated accuracy.
}
\examples{
library(mlbench)
data(Glass)

glass <- Glass[as.numeric(as.character(Glass$Type)) < 3, ]
glass <- glass[sample(1:nrow(glass), 80), ]
y <- ifelse(glass$Type == 1, 0, 1)
x <- glass[, 1:9]

eztune(x, y, type = "binary", method = "gbm", optimizer = "optim")

}
\keyword{adaboost,}
\keyword{gbm,}
\keyword{svm,}
\keyword{tuning}
