% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enmtools.ppmlasso.R
\name{enmtools.ppmlasso}
\alias{enmtools.ppmlasso}
\title{Takes an emtools.species object with presence and background points, and builds a Point Process Model (with Lasso penalty)}
\usage{
enmtools.ppmlasso(
  species,
  env,
  f = NULL,
  test.prop = 0,
  eval = TRUE,
  nback = 1000,
  env.nback = 10000,
  normalise = FALSE,
  report = NULL,
  overwrite = FALSE,
  rts.reps = 0,
  bg.source = "default",
  ...
)
}
\arguments{
\item{species}{An enmtools.species object}

\item{env}{A raster or raster stack of environmental data.}

\item{f}{Standard R formula}

\item{test.prop}{Proportion of data to withhold randomly for model evaluation, or "block" for spatially structured evaluation.}

\item{eval}{Determines whether model evaluation should be done.  Turned on by default, but moses turns it off to speed things up.}

\item{nback}{Number of background points to draw from range or env, if background points aren't provided}

\item{env.nback}{Number of points to draw from environment space for environment space discrimination metrics.}

\item{normalise}{Should the suitability of the model be normalised? If FALSE (the default), suitability is returned as the predicted number of presence points in each grid cell (occurrence density). If TRUE, occurrence densities are divided by the total predicted density, to give a value ranging from 0 to 1, which represents the proportion of the predicted density for a species that occurs in each grid cell.}

\item{report}{Optional name of an html file for generating reports}

\item{overwrite}{TRUE/FALSE whether to overwrite a report file if it already exists}

\item{rts.reps}{The number of replicates to do for a Raes and ter Steege-style test of significance}

\item{bg.source}{Source for drawing background points.  If "points", it just uses the background points that are already in the species object.  If "range", it uses the range raster.  If "env", it draws points at randome from the entire study area outlined by the first environmental layer.}

\item{...}{Arguments to be passed to ppmlasso()}
}
\value{
An enmtools model object containing species name, model formula (if any), model object, suitability raster, marginal response plots, and any evaluation objects that were created.
}
\description{
Takes an emtools.species object with presence and background points, and builds a Point Process Model (with Lasso penalty)
}
\details{
This runs a \code{ppmlasso} model of a species' distribution. It is generally recommended that background points should be on a grid for this method, as the background points are considered 'quadrature' points, used to estimate an integral. If background points are not provided, the function will generate them on a grid, rather than randomly, as is more usual for other SDM methods.
}
\examples{
\dontrun{
install.extras(repos='http://cran.us.r-project.org')
data(euro.worldclim)
data(iberolacerta.clade)
enmtools.ppmlasso(iberolacerta.clade$species$monticola, env = euro.worldclim[[1:3]])
}
}
