% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enmtools.ecospat.id.R
\name{enmtools.ecospat.id}
\alias{enmtools.ecospat.id}
\title{enmtools.ecospat.id, Runs an ecospat identity test using enmtool.species objects.}
\usage{
enmtools.ecospat.id(
  species.1,
  species.2,
  env,
  nreps = 99,
  layers = NULL,
  th.sp = 0,
  th.env = 0,
  R = 100,
  nback = 1000,
  bg.source = "default"
)
}
\arguments{
\item{species.1}{An enmtools.species object}

\item{species.2}{An enmtools.species object}

\item{env}{A set of environmental layers}

\item{nreps}{The number of pseudoreplicates to perform}

\item{layers}{A vector of length 2 containing the names of the layers to be used.  If no layer names are provided and there are more than two layers in env, enmtools will perform a pca and use the top two layers from that.}

\item{th.sp}{Quantile of species densities used as a threshold to exclude low species density values.  See documentation for ecospat.grid.clim.dyn.}

\item{th.env}{Quantile of environmental densities across study sites used as threshold to exclude low
environmental density values.  See documentation for ecospat.grid.clim.dyn.}

\item{R}{Resolution of the grid. See documentation for ecospat.grid.clim.dyn.}

\item{nback}{Number of background points to use for density calculations.}

\item{bg.source}{Source for drawing background points.  If "points", it just uses the background points that are already in the species object.  If "range", it uses the range raster.  If "env", it draws points at randome from the entire study area outlined by the first environmental layer.}
}
\value{
A list containing the ecospat output kernel density estimates for each species and their background, as well as the results of hypothesis tests and their accompanying plots.
}
\description{
enmtools.ecospat.id, Runs an ecospat identity test using enmtool.species objects.
}
\examples{
\donttest{
data(iberolacerta.clade)
data(euro.worldclim)
monticola <- iberolacerta.clade$species$monticola
cyreni <- iberolacerta.clade$species$cyreni
enmtools.ecospat.id(monticola, cyreni, euro.worldclim[[1:2]], nback = 500)
}
}
\keyword{enm}
\keyword{niche}
\keyword{plot}
\keyword{sdm}
