weierstrass <- function(x, a = 0.5, b = 3, kmax = 20) {
  D <- length(x)
  term1 <- sum(sapply(1:D, function(i) {
    sum(sapply(0:kmax, function(k) {
      a^k * cos(2 * pi * b^k * (x[i] + 0.5))
    }))
  }))
  
  term2 <- D * sum(sapply(0:kmax, function(k) {
    a^k * cos(2 * pi * b^k * 0.5)
  }))
  
  return(term1 - term2)
}
