% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CvM.statistic.R
\name{CvM}
\alias{CvM}
\alias{CvM.uniform}
\alias{CvM.normal}
\alias{CvM.gamma}
\alias{CvM.logistic}
\alias{CvM.laplace}
\alias{CvM.weibull}
\alias{CvM.extremevalue}
\alias{CvM.exp}
\title{Cramer-von Mises statistic}
\usage{
CvM.uniform(x, parameter = estimate.uniform(x))

CvM.normal(x, parameter = estimate.normal(x))

CvM.gamma(x, parameter = estimate.gamma(x))

CvM.logistic(x, parameter = estimate.logistic(x))

CvM.laplace(x, parameter = estimate.laplace(x))

CvM.weibull(x, parameter = estimate.weibull(x))

CvM.extremevalue(x)

CvM.exp(x, parameter = estimate.exp(x))

CvM(z)
}
\arguments{
\item{x}{A random sample.}

\item{parameter}{Parameters of the given distribution, MLE by default.}

\item{z}{A standard uniform random sample.}
}
\value{
Cramér-von Mises statistic of the given sample.
}
\description{
Compute the Cramér-von Mises goodness-of-fit statistic \eqn{W^2} for an i.i.d. sample,
x, to test for the given distribution with parameters unknown. Estimate parameters by ML
using \code{EDFtest} MLE function by default.
}
\examples{
x0=runif(n=100,min=-1,max=1)
CvM.uniform(x0)

x1=rnorm(n=100,mean=0,sd=1)
CvM.normal(x1)

x2=rgamma(n=100,shape=1,scale=1)
CvM.gamma(x2)

x3=rlogis(n=100,location=0,scale=1)
CvM.logistic(x3)

x4= rmutil::rlaplace(n=100,m=0,s=1)
CvM.laplace(x4)

x5=rweibull(n=100,shape=1,scale=1)
CvM.weibull(x5)
x5_log=log(x5)
CvM.extremevalue(x5_log)

x6=rexp(n=100,rate=1/2)
CvM.exp(x6)
}
\seealso{
\code{\link{estimate}} for estimating distribution parameters by ML;
\code{\link{AD}} for calculating Anderson-Darling statistic;
\code{\link{Watson}} for calculating Watson statistic;
\code{\link{CvM.pvalue}} for calculating P-value of Cramér-von Mises statistic.
}
