% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E4.extras.BinEDA.R
\name{E4.extras.BinEDA}
\alias{E4.extras.BinEDA}
\title{Extras: Make EDA bins}
\usage{
E4.extras.BinEDA(participant_list, rdslocation.EDA, rdslocation.binnedEDA,
  BinLengthMin, RejectFlag = TRUE)
}
\arguments{
\item{participant_list}{list of participant numbers NOTE: This should match the names of the folders (e.g., participant 1001's data should be in a folder called "1001")}

\item{rdslocation.EDA}{folder location where raw EDA (from part 1) is saved.}

\item{rdslocation.binnedEDA}{folder location where you want the RDS outputs to go (make sure that it ends in /)}

\item{BinLengthMin}{folder location where you want the RDS outputs to go (make sure that it ends in /)}

\item{RejectFlag}{Did you include in step 1 the option to keep the flag that shows which data the high and low pass filters rejected (By default, these are included in step 1) AND do you want to include a summary in this dataset of how many samples in a bin were rejected? If you want to run the diagnostic steps, you must keep this. Defaults to TRUE.}
}
\description{
Put EDA data in bins of X minutes length
}
\examples{
E4.extras.BinEDA(participant_list=c(1001:1002),
rdslocation.EDA=paste(system.file(package="E4tools"),"/extdata/output/raw_EDA/",sep=""),
rdslocation.binnedEDA=paste(tempdir(),"/extdata/output/binned_EDA/",sep=""),
BinLengthMin=2,RejectFlag=TRUE)
}
\keyword{EDA}
