% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateDrugUtilisationCohortSet.R
\name{generateDrugUtilisationCohortSet}
\alias{generateDrugUtilisationCohortSet}
\title{Generate a set of drug cohorts based on given concepts}
\usage{
generateDrugUtilisationCohortSet(
  cdm,
  name,
  conceptSet,
  gapEra = 1,
  subsetCohort = NULL,
  subsetCohortId = NULL,
  numberExposures = FALSE,
  daysPrescribed = FALSE,
  durationRange = lifecycle::deprecated(),
  imputeDuration = lifecycle::deprecated(),
  priorUseWashout = lifecycle::deprecated(),
  priorObservation = lifecycle::deprecated(),
  cohortDateRange = lifecycle::deprecated(),
  limit = lifecycle::deprecated()
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object.}

\item{name}{Name of the new cohort table, it must be a length 1 character
vector.}

\item{conceptSet}{List of concepts to be included.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era.}

\item{subsetCohort}{Cohort table to subset.}

\item{subsetCohortId}{Cohort id to subset.}

\item{numberExposures}{Whether to include 'number_exposures' (number of drug
exposure records between indexDate and censorDate).}

\item{daysPrescribed}{Whether to include 'days_prescribed' (number of days
prescribed used to create each era).}

\item{durationRange}{Deprecated.}

\item{imputeDuration}{Deprecated.}

\item{priorUseWashout}{Deprecated.}

\item{priorObservation}{Deprecated.}

\item{cohortDateRange}{Deprecated.}

\item{limit}{Deprecated.}
}
\value{
The function returns the cdm reference provided with the addition of
the new cohort table.
}
\description{
Adds a new cohort table to the cdm reference with individuals who have drug
exposure records with the specified concepts. Cohort start and end dates will
be based on drug record start and end dates, respectively. Records that
overlap or have fewer days between them than the specified gap era will be
concatenated into a single cohort entry.
}
\examples{
\donttest{
library(CDMConnector)
library(DrugUtilisation)
library(dplyr)

cdm <- mockDrugUtilisation()

druglist <- CodelistGenerator::getDrugIngredientCodes(
  cdm, c("acetaminophen", "metformin"), nameStyle = "{concept_name}"
)

cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm,
  name = "drug_cohorts",
  conceptSet = druglist,
  gapEra = 30,
  numberExposures = TRUE,
  daysPrescribed = TRUE
)

cdm$drug_cohorts |>
  glimpse()
}

}
