% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDrugUtilisation.R
\name{addNumberEras}
\alias{addNumberEras}
\title{To add a new column with the number of eras. To add multiple columns use
\code{addDrugUtilisation()} for efficiency.}
\usage{
addNumberEras(
  cohort,
  conceptSet,
  gapEra,
  indexDate = "cohort_start_date",
  censorDate = "cohort_end_date",
  restrictIncident = TRUE,
  nameStyle = "number_eras_{concept_name}",
  name = NULL
)
}
\arguments{
\item{cohort}{Cohort in the cdm.}

\item{conceptSet}{List of concepts to be included.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era.}

\item{indexDate}{Name of a column that indicates the date to start the
analysis.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{restrictIncident}{Whether to include only incident prescriptions in the
analysis. If FALSE all prescriptions that overlap with the study period will
be included.}

\item{nameStyle}{Character string to specify the nameStyle of the new columns.}

\item{name}{Name of the new computed cohort table, if NULL a temporary tables is
created.}
}
\value{
The same cohort with the added column.
}
\description{
To add a new column with the number of eras. To add multiple columns use
\code{addDrugUtilisation()} for efficiency.
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()
codelist <- CodelistGenerator::getDrugIngredientCodes(
  cdm,
  name = "acetaminophen"
)
cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm, name = "dus_cohort", conceptSet = codelist
)

cdm$dus_cohort |>
  addNumberEras(conceptSet = codelist, gapEra = 1)
}

}
