% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableProportionOfPatientsCovered}
\alias{tableProportionOfPatientsCovered}
\title{Create a table with proportion of patients covered results}
\usage{
tableProportionOfPatientsCovered(
  result,
  times = NULL,
  header = c("group", "strata"),
  splitStrata = TRUE,
  cohortName = TRUE,
  cdmName = TRUE,
  groupColumn = "variable_name",
  type = "gt",
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object with results from
summariseProportionOfPatientsCovered().}

\item{times}{Days to include in the table. If NULL all days will be
included.}

\item{header}{A vector containing which elements should go into the header
in order. Allowed are: \code{cdm_name}, \code{group}, \code{strata}, \code{variable}.}

\item{splitStrata}{If TRUE strata columns will be split.}

\item{cohortName}{If TRUE cohort names will be displayed.}

\item{cdmName}{If TRUE database names will be displayed.}

\item{groupColumn}{Column to use as group labels.}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{.options}{Named list with additional formatting options.
DrugUtilisation::defaultTableOptions() shows allowed
arguments and their default values.}
}
\value{
A table with a formatted version of summariseProportionOfPatientsCovered() results.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
