% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern.R
\name{stratifyByUnit}
\alias{stratifyByUnit}
\title{Function to stratify a conceptSet by unit}
\usage{
stratifyByUnit(conceptSet, cdm, ingredientConceptId)
}
\arguments{
\item{conceptSet}{List of concept sets}

\item{cdm}{cdm reference}

\item{ingredientConceptId}{ConceptId that refers to an ingredient}
}
\value{
The conceptSet stratified by unit
}
\description{
Function to stratify a conceptSet by unit
}
\examples{
\donttest{
library(DrugUtilisation)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()

codelist <- getDrugIngredientCodes(cdm, "acetaminophen")

codelistStratified <- stratifyByUnit(codelist, cdm, 1125315)

codelistStratified
}

}
