% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateConceptCohortSet.R
\name{generateConceptCohortSet}
\alias{generateConceptCohortSet}
\title{Generates a cohort for a certain list of concepts.}
\usage{
generateConceptCohortSet(
  cdm,
  name,
  conceptSetList,
  daysPriorObservation = 0,
  gap = 0,
  washout = 0,
  offset = 0,
  cohortDateRange = as.Date(c(NA, NA))
)
}
\arguments{
\item{cdm}{'cdm' object created with CDMConnector::cdm_from_con().}

\item{name}{Name of the GeneratedCohortSet.}

\item{conceptSetList}{Named list of concept sets.}

\item{daysPriorObservation}{Minimum number of days of prior observation
required for the incident events. If NULL, it is not required that the event
is within the observation period.}

\item{gap}{Number of days between two events to be joined.}

\item{washout}{Prior days of washout without a previous event.}

\item{offset}{Number of days of offset after the cohort_end_date.}

\item{cohortDateRange}{Range for cohort_start_date and cohort_end_date}
}
\value{
The function returns the 'cdm' object with the created cohort.
}
\description{
Generates a cohort for a certain list of concepts.
}
\examples{
\donttest{
library(DrugUtilisation)
library(CDMConnector)

cdm <- mockDrugUtilisation()

conditions <- list("headache" = 378253, "asthma" = 317009)

cdm <- generateConceptCohortSet(
  cdm = cdm,
  name = "covariates",
  conceptSetList = conditions,
  daysPriorObservation = 365
)

cdm$covariates

cohortSet(cdm$covariates)

cohortCount(cdm$covariates)

cohortAttrition(cdm$covariates)
}

}
