% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGF_exp.R
\name{MGF_exp}
\alias{MGF_exp}
\title{Moment Generating Function of the Exponential distribution}
\usage{
MGF_exp(t, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{t}{t.}

\item{rate}{\eqn{\beta}{beta} is the rate parameter, must be positive.}

\item{scale}{alternative parameterization to rate parameter, scale = 1 / rate.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_exp}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{E_exp}}}{ gives the expected value.}
 \item{\code{\link{V_exp}}}{ gives the variance.}
 \item{\code{\link{kthmoment_exp}}}{ gives the kth moment.}
 \item{\code{\link{Etronq_exp}}}{ gives the truncated mean.}
 \item{\code{\link{SL_exp}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_exp}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_exp}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_exp}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_exp}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Moment Generating Function (MGF) of the Exponential
 distribution with rate parameter \eqn{\beta}{beta}.
}
\details{
The Exponential distribution with rate parameter \eqn{\beta}{b} has %
  density: \deqn{f\left(x\right) = \frac{1}{\beta}%
  \textrm{e}^{-\beta x}}{f(x) = b^a e^{-b x}} for %
  \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\beta > 0}{b > 0}.
}
\examples{

MGF_exp(t = 1, rate = 5)

}
\seealso{
Other Exponential Distribution: 
\code{\link{E_exp}()},
\code{\link{Elim_exp}()},
\code{\link{Etronq_exp}()},
\code{\link{Mexcess_exp}()},
\code{\link{SL_exp}()},
\code{\link{TVaR_exp}()},
\code{\link{V_exp}()},
\code{\link{VaR_exp}()},
\code{\link{kthmoment_exp}()}
}
\concept{Exponential Distribution}
