% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E_burr.R
\name{E_burr}
\alias{E_burr}
\title{Expected value of the Burr distribution}
\usage{
E_burr(shape1, shape2, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{shape1}{first shape parameter \eqn{\alpha}{alpha}, must be positive integer.}

\item{shape2}{second shape parameter \eqn{\tau}{tau}, must be positive integer.}

\item{rate}{\eqn{\lambda}{lambda} is the rate parameter, must be positive.}

\item{scale}{alternative parameterization to rate parameter, scale = 1 / rate.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{E_burr}}}{ gives the expected value.}
 \item{\code{\link{V_burr}}}{ gives the variance.}
 \item{\code{\link{kthmoment_burr}}}{ gives the kth moment.}
 \item{\code{\link{Etronq_burr}}}{ gives the truncated mean.}
 \item{\code{\link{SL_burr}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_burr}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_burr}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_burr}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_burr}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Expected value of the Burr distribution with shape parameters
 \eqn{\alpha}{alpha} (shape1) and \eqn{\tau}{tau} (shape2) as well as
 rate parameter \eqn{\lambda}{lambda}.
}
\details{
The Burr distribution with rate parameter \eqn{\lambda}{lam} as well as shape
  parameters \eqn{\alpha}{a} and \eqn{\tau}{t} has density:
  \deqn{f\left(x\right) = \frac{\alpha \tau \lambda^{ \alpha } x^{ \tau - 1 }}{(\lambda + x^{ \tau })^{\alpha +1}}}{f(x) = (a t lam^a x^(t - 1))/ (lam + x^t)^(a + 1)}
  for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\alpha, \tau, \lambda > 0}{a, t, lam > 0}.
}
\examples{

# With scale parameter
E_burr(rate = 2, shape1 = 2, shape2 = 5)

# With rate parameter
E_burr(scale = 0.5, shape1 = 2, shape2 = 5)

}
\seealso{
Other Burr Distribution: 
\code{\link{Elim_burr}()},
\code{\link{Etronq_burr}()},
\code{\link{Mexcess_burr}()},
\code{\link{SL_burr}()},
\code{\link{TVaR_burr}()},
\code{\link{V_burr}()},
\code{\link{VaR_burr}()},
\code{\link{kthmoment_burr}()}
}
\concept{Burr Distribution}
