% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pile.down.R
\name{pile.down}
\alias{pile.down}
\title{Destacks a pile.up() signal}
\usage{
pile.down(x, stack, even, n = length(unique(stack$id)) - 2)
}
\arguments{
\item{x}{Treated signal}

\item{stack}{Initial stack from which the x signal is from}

\item{even}{Whether the x signal comes from even extension part of the
initial stack (if FALSE, it would come from the odd extension part)}

\item{n}{The multiple of destacking (has to be a multiple of n/2 (n being the
parameter used in \code{\link{pile.up}}), in other words a multiple of
length(unique(stack$id)) - 2 (minus 2 as the upper an lower extension are to
be removed)}
}
\value{
a matrix or a vector of the destacked signal
}
\description{
Destacks a signal stacked by \code{\link{pile.up}} by averaging
each repetition back to n multiples.
}
\examples{
set.seed(42)

n <- 200
t <- seq_len(n)

p1 <- 25
p2 <- 75

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5)

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)
inter_dt[20] <- 20

dt <- cumsum(inter_dt)

opar <- par()$mfrow
par(mfrow = c(1,1))

res <- pile.up(xy, dt, 4)

par(mfrow = c(2,1))
plot(res$ndt, res$even, type = "l", col = "blue")
plot(res$ndt, res$odd,  type = "l", col = "red")

par(mfrow = c(opar))

# Small number of repetitions ----

opar <- par("mfrow")
par(mfrow = c(1,2))

stack <- pile.up(xy, dt, 10)

signal <- stack$even + runif(length(stack$even), -3, 3)

res <- pile.down(signal, stack, even = TRUE, n = 5)

plot(xy, dt, type = "l", lwd = 2, main = "Low number of repetitions")
lines(res, dt,  type = "l", lty = 5, col = "red")

# High number of repetitions ----

stack <- pile.up(xy, dt, 1000)

signal <- stack$even + runif(length(stack$even), -3, 3)

res <- pile.down(signal, stack, even = TRUE, n = 500)

plot(xy, dt, type = "l", lwd = 2, main = "High number of repetitions")
lines(res, dt,  type = "l", lty = 5, col = "red")

par(mfrow = c(opar))

}
