/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarLexer;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.Logger;
import net.starschema.clouddb.jdbc.antlr.sqlparse.ColumnCallException;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.CallContainer;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.Parameter;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.SourceTable;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.Tree;

public class TreeBuilder {
    Tree tree;
    String sqlForParse;
    List<String> UniqueIds;
    CallContainer callContainer;
    int nextIdPosition = -1;
    Connection connection;
    Logger logger = Logger.getLogger(this.getClass());

    public TreeBuilder(String sqlforparse, Connection connection, CallContainer callContainer) {
        this.sqlForParse = sqlforparse;
        this.connection = connection;
        this.callContainer = callContainer;
    }

    public Tree buildTree() throws Exception {
        this.sqlForParse = this.sqlForParse.replace('`', '\"').replace('\r', ' ').replace('\n', ' ');
        this.logger.debug("Building the ANTLR tree");
        ANTLRStringStream stream = new ANTLRStringStream(this.sqlForParse);
        JdbcGrammarLexer lexer = new JdbcGrammarLexer(stream);
        CommonTokenStream tokenstream = new CommonTokenStream(lexer);
        JdbcGrammarParser parser = new JdbcGrammarParser(tokenstream);
        try {
            this.tree = (Tree)parser.statement().getTree();
        }
        catch (RecognitionException e) {
            this.logger.warn("Grammar error: Failed to parse the Query", e);
            throw new Exception("Grammar error: Failed to parse the Query", e);
        }
        return this.tree;
    }

    public Node buildSelect() throws Exception {
        this.buildTree();
        this.logger.debug("Creating a new SelectStatement with the builded tree");
        try {
            return new SelectStatement(this.tree, this);
        }
        catch (TreeParsingException e) {
            this.logger.warn("Something went wrong with the TreeBuilding", e);
            throw new Exception("Something went wrong with the TreeBuilding", e);
        }
        catch (ColumnCallException e) {
            this.logger.warn("Ambiguous ColumnCall found", e);
            throw new Exception("Ambiguous ColumnCall found", e);
        }
    }

    List<String> getPossiblePrefixes(String colName) {
        this.logger.debug("making a jdbc call to get the Prefixes");
        ArrayList<String> Columns = new ArrayList<String>();
        try {
            this.logger.debug("Try to get result from container first");
            Class[] args = new Class[]{String.class, String.class, String.class, String.class};
            Method method = null;
            try {
                this.logger.debug("getting the method: getcolumns");
                method = this.connection.getMetaData().getClass().getMethod("getColumns", args);
            }
            catch (SecurityException e) {
                this.logger.warn("failed to get the method getColumns " + e);
            }
            catch (NoSuchMethodException e) {
                this.logger.warn("failed to get the method getColumns " + e);
            }
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            params.add(new Parameter(this.connection.getCatalog()));
            params.add(new Parameter("%"));
            params.add(new Parameter("%"));
            params.add(new Parameter(colName));
            ResultSet res = this.callContainer.getresult(method, params);
            if (res == null) {
                res = this.connection.getMetaData().getColumns(this.connection.getCatalog(), "%", "%", colName);
                this.callContainer.AddCall(res, method, params);
            }
            res.first();
            while (!res.isAfterLast()) {
                Columns.add(res.getString(2) + "." + res.getString(3));
                this.logger.debug("found prefix:" + res.getString(2) + "." + res.getString(3));
                res.next();
            }
        }
        catch (SQLException e) {
            this.logger.warn("failed to get prefixes for the column: " + colName, e);
        }
        return Columns;
    }

    List<String> GetColumns(SourceTable srcTable) {
        this.logger.debug("making a jdbc call to get the columns");
        ArrayList<String> Columns = new ArrayList<String>();
        try {
            this.logger.debug("Try to get result from container first");
            Class[] args = new Class[]{String.class, String.class, String.class, String.class};
            Method method = null;
            try {
                this.logger.debug("getting the method: MetaData.getColumns");
                method = this.connection.getMetaData().getClass().getMethod("getColumns", args);
            }
            catch (SecurityException e) {
                this.logger.warn("failed to get the method getColumns " + e);
            }
            catch (NoSuchMethodException e) {
                this.logger.warn("failed to get the method getColumns " + e);
            }
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            String projectName = null;
            projectName = srcTable.project != null ? srcTable.getProject().replace(".", "_").replace(":", "__") : this.connection.getCatalog();
            String dataset = srcTable.dataset != null ? srcTable.dataset : "%";
            params.add(new Parameter(projectName));
            params.add(new Parameter(dataset));
            params.add(new Parameter(srcTable.getName()));
            params.add(new Parameter("%"));
            ResultSet res = this.callContainer.getresult(method, params);
            if (res == null) {
                res = this.connection.getMetaData().getColumns(projectName, dataset, srcTable.getName(), "%");
                this.callContainer.AddCall(res, method, params);
            }
            res.first();
            while (!res.isAfterLast()) {
                Columns.add(res.getString(4));
                res.next();
            }
        }
        catch (SQLException e) {
            this.logger.warn("failed to get columns for the table: \"" + srcTable.getName() + "\" using * instead of columns", e);
            Columns.add("*");
        }
        return Columns;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getuniqueid() {
        if (this.nextIdPosition < 0) {
            this.makeUniqueId();
        }
        return this.UniqueIds.get(this.nextIdPosition++);
    }

    private void makeUniqueId() {
        this.nextIdPosition = 0;
        int seqWidth = 4;
        Double charSetSize = 26.0;
        Double total = Math.pow(charSetSize, new Integer(seqWidth).doubleValue());
        StringBuilder[] sbArr = new StringBuilder[total.intValue()];
        int j = 0;
        while ((double)j < total) {
            sbArr[j] = new StringBuilder();
            ++j;
        }
        int ch = 65;
        for (int k = seqWidth; k > 0; --k) {
            int l = 1;
            while ((double)l <= total) {
                sbArr[l - 1].append((char)ch);
                if ((double)l % Math.pow(charSetSize, (double)k - 1.0) == 0.0 && (ch = (char)(ch + '\u0001')) > 90) {
                    ch = 65;
                }
                ++l;
            }
        }
        this.UniqueIds = new ArrayList<String>();
        for (StringBuilder id : sbArr) {
            this.UniqueIds.add("UNIQ_ID_" + id);
        }
    }
}

