% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbColumnInfo,DatabaseConnectorResult-method}
\alias{dbColumnInfo,DatabaseConnectorResult-method}
\title{Information about result types}
\usage{
\S4method{dbColumnInfo}{DatabaseConnectorResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbColumnInfo()}
returns a data frame
with at least two columns \code{"name"} and \code{"type"} (in that order)
(and optional columns that start with a dot).
The \code{"name"} and \code{"type"} columns contain the names and types
of the R columns of the data frame that is returned from \code{\link[DBI:dbFetch]{dbFetch()}}.
The \code{"type"} column is of type \code{character} and only for information.
Do not compute on the \code{"type"} column, instead use \code{dbFetch(res, n = 0)}
to create a zero-row data frame initialized with the correct data types.

An attempt to query columns for a closed result set raises an error.
}
\description{
Produces a data.frame that describes the output of a query. The data.frame
should have as many rows as there are output fields in the result set, and
each column in the data.frame describes an aspect of the result set
field (field name, type, etc.)
}
\seealso{
Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()},
\code{\link[DBI]{dbUnquoteIdentifier}()}
}
